/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.util.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.feedzai.openml.data.schema.DatasetSchema;
import com.feedzai.openml.data.schema.FieldSchema;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class DatasetSchemaDeserializer
extends StdDeserializer<DatasetSchema> {
    public static final String TARGET_INDEX = "targetIndex";
    public static final String FIELD_SCHEMAS = "fieldSchemas";

    public DatasetSchemaDeserializer() {
        this(null);
    }

    public DatasetSchemaDeserializer(Class<?> vc) {
        super(vc);
    }

    public DatasetSchema deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode treeNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        Optional<Integer> targetIndex = Optional.ofNullable(treeNode.get(TARGET_INDEX)).map(JsonNode::intValue);
        JsonNode fieldNode = treeNode.get(FIELD_SCHEMAS);
        List schemaList = (List)jsonParser.getCodec().readValue(fieldNode.traverse(jsonParser.getCodec()), (TypeReference)new TypeReference<List<FieldSchema>>(){});
        return targetIndex.map(index -> new DatasetSchema(index.intValue(), schemaList)).orElse(new DatasetSchema(schemaList));
    }
}

