/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.util.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.feedzai.openml.data.schema.AbstractValueSchema;
import com.feedzai.openml.data.schema.FieldSchema;
import java.io.IOException;

public class FieldSchemaDeserializer
extends StdDeserializer<FieldSchema> {
    public static final String FIELD_NAME = "fieldName";
    public static final String FIELD_INDEX = "fieldIndex";
    public static final String VALUE_SCHEMA = "valueSchema";

    public FieldSchemaDeserializer() {
        this(null);
    }

    public FieldSchemaDeserializer(Class<?> vc) {
        super(vc);
    }

    public FieldSchema deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode treeNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String fieldName = treeNode.get(FIELD_NAME).textValue();
        int fieldIndex = (Integer)treeNode.get(FIELD_INDEX).numberValue();
        JsonNode valueSchemaNode = treeNode.get(VALUE_SCHEMA);
        AbstractValueSchema valueSchema = (AbstractValueSchema)jsonParser.getCodec().readValue(valueSchemaNode.traverse(jsonParser.getCodec()), (TypeReference)new TypeReference<AbstractValueSchema>(){});
        return new FieldSchema(fieldName, fieldIndex, valueSchema);
    }
}

