/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.util.jackson.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.feedzai.openml.data.schema.AbstractValueSchema;
import com.feedzai.openml.data.schema.CategoricalValueSchema;
import com.feedzai.openml.data.schema.NumericValueSchema;
import com.feedzai.openml.data.schema.StringValueSchema;
import java.io.IOException;

public class AbstractValueSchemaSerializer
extends StdSerializer<AbstractValueSchema> {
    public AbstractValueSchemaSerializer() {
        this(null);
    }

    public AbstractValueSchemaSerializer(Class<AbstractValueSchema> t) {
        super(t);
    }

    public void serialize(AbstractValueSchema valueSchema, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        if (valueSchema instanceof CategoricalValueSchema) {
            jsonGenerator.writeStringField("@type", "categorical");
            jsonGenerator.writeObjectField("nominalValues", (Object)((CategoricalValueSchema)valueSchema).getNominalValues());
        } else if (valueSchema instanceof NumericValueSchema) {
            jsonGenerator.writeStringField("@type", "numeric");
        } else if (valueSchema instanceof StringValueSchema) {
            jsonGenerator.writeStringField("@type", "string");
        } else {
            throw new UnsupportedOperationException(String.format("A unknown field type [%s] was found.", valueSchema));
        }
        jsonGenerator.writeBooleanField("allowMissing", valueSchema.isAllowMissing());
        jsonGenerator.writeEndObject();
    }
}

