/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.util.load;

import com.feedzai.openml.provider.exception.ModelLoadingException;
import java.io.File;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadModelUtils {
    private static final Logger logger = LoggerFactory.getLogger(LoadModelUtils.class);
    public static final String MODEL_FOLDER = "model";

    private LoadModelUtils() {
    }

    public static Path getModelFilePath(Path modelDirectoryPath) throws ModelLoadingException {
        File modelDirectoryFile = modelDirectoryPath.toFile();
        if (!modelDirectoryFile.exists() || modelDirectoryFile.isFile()) {
            String errorMsg = String.format("The path [%s] should be a directory", modelDirectoryPath);
            logger.error(errorMsg);
            throw new ModelLoadingException(errorMsg);
        }
        if (!modelDirectoryFile.canExecute()) {
            String errorMsg = String.format("Lacking execute permissions in directory [%s]", modelDirectoryPath);
            logger.error(errorMsg);
            throw new ModelLoadingException(errorMsg);
        }
        Path binaryDirectoryPath = modelDirectoryPath.resolve(MODEL_FOLDER);
        File binaryDirectoryFile = binaryDirectoryPath.toFile();
        if (!binaryDirectoryFile.exists() || binaryDirectoryFile.isFile()) {
            String errorMsg = String.format("The path [%s] should be a directory", binaryDirectoryFile.getAbsoluteFile());
            logger.error(errorMsg);
            throw new ModelLoadingException(errorMsg);
        }
        if (!binaryDirectoryFile.canExecute() || !binaryDirectoryFile.canRead()) {
            String errorMsg = String.format("Cannot read the contents of the directory [%s]", binaryDirectoryFile.getAbsoluteFile());
            logger.error(errorMsg);
            throw new ModelLoadingException(errorMsg);
        }
        File[] files = binaryDirectoryFile.listFiles();
        if (files == null || files.length != 1) {
            String errorMsg = String.format("There should be exactly one file inside [%s]", binaryDirectoryFile.getAbsoluteFile());
            logger.error(errorMsg);
            throw new ModelLoadingException(errorMsg);
        }
        File modelFile = files[0];
        if (modelFile.isDirectory()) {
            String errorMsg = String.format("The path [%s] should be a file", modelFile.getAbsoluteFile());
            logger.error(errorMsg);
            throw new ModelLoadingException(errorMsg);
        }
        if (!modelFile.canRead()) {
            String errorMsg = String.format("Cannot open the model file for reading [%s]", modelFile.getAbsoluteFile());
            logger.error(errorMsg);
            throw new ModelLoadingException(errorMsg);
        }
        return modelFile.toPath();
    }
}

