/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.util.load;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.feedzai.openml.data.schema.AbstractValueSchema;
import com.feedzai.openml.data.schema.CategoricalValueSchema;
import com.feedzai.openml.data.schema.DatasetSchema;
import com.feedzai.openml.data.schema.NumericValueSchema;
import com.feedzai.openml.provider.exception.ModelLoadingException;
import com.feedzai.openml.util.jackson.SerializersInModule;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadSchemaUtils {
    private static final Logger logger = LoggerFactory.getLogger(LoadSchemaUtils.class);
    private static final String SCHEMA_IMPORT_MODEL = "model.json";
    public static final String CATEGORICAL = "categorical";
    public static final String NUMERIC = "numeric";
    public static final String STRING = "string";

    private LoadSchemaUtils() {
    }

    public static DatasetSchema datasetSchemaFromJson(Path filePath) throws ModelLoadingException {
        if (!Files.isDirectory(filePath, new LinkOption[0])) {
            throw new ModelLoadingException("The path should be a directory");
        }
        Path jsonFilePath = filePath.resolve(SCHEMA_IMPORT_MODEL);
        if (!Files.exists(jsonFilePath, new LinkOption[0])) {
            throw new ModelLoadingException("There is no model.json file on the model path.");
        }
        try {
            String jsonContent = new String(Files.readAllBytes(jsonFilePath));
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new SerializersInModule());
            return (DatasetSchema)mapper.readValue(jsonContent, DatasetSchema.class);
        }
        catch (IOException e) {
            String msg = String.format("Could not load schema for model in path %s due to %s", filePath, e.toString());
            logger.error(msg);
            logger.trace(msg, (Throwable)e);
            throw new ModelLoadingException(e.toString());
        }
    }

    public static String getValueSchemaTypeToString(AbstractValueSchema valueSchema) {
        if (valueSchema instanceof CategoricalValueSchema) {
            return CATEGORICAL;
        }
        if (valueSchema instanceof NumericValueSchema) {
            return NUMERIC;
        }
        return STRING;
    }
}

