/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.util.validate;

import com.feedzai.openml.data.schema.DatasetSchema;
import com.feedzai.openml.mocks.MockDataset;
import com.feedzai.openml.model.ClassificationMLModel;
import com.feedzai.openml.provider.descriptor.fieldtype.ParamValidationError;
import com.feedzai.openml.provider.exception.ModelLoadingException;
import com.feedzai.openml.provider.model.MachineLearningModelLoader;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassificationValidationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClassificationValidationUtils.class);

    private ClassificationValidationUtils() {
    }

    public static void validateClassificationModel(DatasetSchema schema, ClassificationMLModel model) throws ModelLoadingException {
        Preconditions.checkNotNull((Object)schema, (Object)"schema cannot be null");
        Preconditions.checkNotNull((Object)model, (Object)"model cannot be null");
        MockDataset mockDataset = new MockDataset(schema, 1, new Random(0L));
        try {
            model.classify(mockDataset.instance(0));
        }
        catch (RuntimeException e) {
            String msg = String.format("Model classification is not compatible with the given schema %s.", schema);
            logger.error(msg, (Throwable)e);
            throw new ModelLoadingException(msg, (Throwable)e);
        }
        try {
            model.getClassDistribution(mockDataset.instance(0));
        }
        catch (RuntimeException e) {
            String msg = "Model does not support class distribution.";
            logger.error("Model does not support class distribution.", (Throwable)e);
            throw new ModelLoadingException("Model does not support class distribution.", (Throwable)e);
        }
    }

    public static void validateParamsModelToLoad(MachineLearningModelLoader modelLoader, Path modelPath, DatasetSchema schema, Map<String, String> params) throws ModelLoadingException {
        Preconditions.checkNotNull((Object)modelLoader, (Object)"modelLoader cannot be null");
        Preconditions.checkNotNull((Object)modelPath, (Object)"modelPath cannot be null");
        Preconditions.checkNotNull((Object)schema, (Object)"schema cannot be null");
        Preconditions.checkNotNull(params, (Object)"params cannot be null");
        logger.debug("Validating the parameters of the model in path [{}]", (Object)modelPath);
        List validationErrors = modelLoader.validateForLoad(modelPath, schema, params);
        if (!validationErrors.isEmpty()) {
            String errorMsg = validationErrors.stream().map(ParamValidationError::getMessage).collect(Collectors.joining(","));
            throw new ModelLoadingException(errorMsg);
        }
        logger.debug("Parameters of the model in path [{}] successfully validated", (Object)modelPath);
    }
}

