/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.openml.util.validate;

import com.feedzai.openml.data.schema.AbstractValueSchema;
import com.feedzai.openml.data.schema.CategoricalValueSchema;
import com.feedzai.openml.data.schema.DatasetSchema;
import com.feedzai.openml.data.schema.FieldSchema;
import com.feedzai.openml.provider.descriptor.MLAlgorithmDescriptor;
import com.feedzai.openml.provider.descriptor.ModelParameter;
import com.feedzai.openml.provider.descriptor.fieldtype.ParamValidationError;
import com.feedzai.openml.provider.exception.ModelLoadingException;
import com.feedzai.openml.util.load.LoadModelUtils;
import com.feedzai.openml.util.load.LoadSchemaUtils;
import com.google.common.collect.ImmutableList;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ValidationUtils.class);

    private ValidationUtils() {
    }

    public static List<ParamValidationError> checkParams(MLAlgorithmDescriptor algorithmDescriptor, Map<String, String> params) {
        ImmutableList.Builder errorsBuilder = ImmutableList.builder();
        algorithmDescriptor.getParameters().forEach(parameterConfig -> {
            String parameterName = parameterConfig.getName();
            String value = (String)params.get(parameterName);
            ValidationUtils.checkMandatoryParam(parameterConfig, value).ifPresent(arg_0 -> ((ImmutableList.Builder)errorsBuilder).add(arg_0));
            ValidationUtils.checkParam(parameterConfig, value).ifPresent(arg_0 -> ((ImmutableList.Builder)errorsBuilder).add(arg_0));
        });
        return errorsBuilder.build();
    }

    private static Optional<ParamValidationError> checkMandatoryParam(ModelParameter parameter, String parameterValue) {
        if (null == parameterValue && parameter.isMandatory()) {
            return Optional.of(new ParamValidationError(parameter.getName(), parameterValue, String.format("The parameter %s must have a value since it's mandatory", parameter.getName())));
        }
        return Optional.empty();
    }

    private static Optional<ParamValidationError> checkParam(ModelParameter parameter, String parameterValue) {
        if (parameterValue != null) {
            return parameter.getFieldType().validate(parameter.getName(), parameterValue);
        }
        return Optional.empty();
    }

    public static Optional<ParamValidationError> validateCategoricalSchema(DatasetSchema schema) {
        Optional targetFieldOrNone = schema.getTargetFieldSchema();
        if (!targetFieldOrNone.isPresent()) {
            return Optional.of(new ParamValidationError("The dataset provided has no target variable."));
        }
        FieldSchema targetField = (FieldSchema)targetFieldOrNone.get();
        AbstractValueSchema targetSchemaType = targetField.getValueSchema();
        Supplier<SortedSet> categoricalNominalValues = () -> ((CategoricalValueSchema)targetSchemaType).getNominalValues();
        if (!(targetSchemaType instanceof CategoricalValueSchema)) {
            return Optional.of(new ParamValidationError(String.format("Target variable %s must be a categorical field", targetField.getFieldName())));
        }
        if (categoricalNominalValues.get().size() < 2) {
            String message = String.format("Target variable %s must be a categorical field with at least 2 values, but only has %s.", targetField.getFieldName(), categoricalNominalValues.get().size());
            return Optional.of(new ParamValidationError(message));
        }
        return Optional.empty();
    }

    public static List<ParamValidationError> validateModelInDir(Path modelPath) {
        try {
            LoadModelUtils.getModelFilePath(modelPath);
        }
        catch (ModelLoadingException e) {
            String msg = String.format("Could not load model from path %s: %s", modelPath, e.getMessage());
            logger.warn(msg);
            return ImmutableList.of((Object)new ParamValidationError(msg));
        }
        return Collections.emptyList();
    }

    public static List<ParamValidationError> baseLoadValidations(DatasetSchema schema, Map<String, String> params) {
        ImmutableList.Builder errorBuilder = ImmutableList.builder();
        if (Objects.isNull(schema)) {
            errorBuilder.add((Object)new ParamValidationError("DatasetSchema cannot be null"));
        }
        if (Objects.isNull(params)) {
            errorBuilder.add((Object)new ParamValidationError("The map of parameters cannot be null"));
        }
        return errorBuilder.build();
    }

    public static List<ParamValidationError> checkNoFieldsOfType(DatasetSchema schema, Class<? extends AbstractValueSchema> fieldClass) {
        ImmutableList.Builder errors = ImmutableList.builder();
        schema.getPredictiveFields().stream().filter(field -> fieldClass.isInstance(field.getValueSchema())).forEach(field -> errors.add((Object)new ParamValidationError(String.format("field [%s] is of unsupported type [%s]", field.getFieldName(), LoadSchemaUtils.getValueSchemaTypeToString(field.getValueSchema())))));
        return errors.build();
    }

    public static List<ParamValidationError> validateModelPathToTrain(Path pathToPersist) {
        try {
            if (pathToPersist.toFile().exists() && Files.list(pathToPersist).count() != 0L) {
                String msg = String.format("The selected folder %s to persist the Machine Learning Model (yet to be trained) must be empty but is currently not.", pathToPersist);
                return Collections.singletonList(new ParamValidationError(msg));
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected error while verifying indicated directory {} to persist ML model (to be trained).", (Object)pathToPersist);
            String msg = String.format("Could not access the selected folder %s to persist the Machine Learning Model (yet to be trained) due to error %s.", pathToPersist, e.getMessage());
            return Collections.singletonList(new ParamValidationError(msg));
        }
        return Collections.emptyList();
    }
}

