/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.batch;

import com.feedzai.commons.sql.abstraction.FailureListener;
import com.feedzai.commons.sql.abstraction.batch.AbstractPdbBatch;
import com.feedzai.commons.sql.abstraction.batch.BatchConfig;
import com.feedzai.commons.sql.abstraction.batch.BatchEntry;
import com.feedzai.commons.sql.abstraction.batch.PdbBatch;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import com.feedzai.commons.sql.abstraction.listeners.BatchListener;
import com.feedzai.commons.sql.abstraction.listeners.MetricsListener;
import com.feedzai.commons.sql.abstraction.listeners.impl.NoopBatchListener;
import com.feedzai.commons.sql.abstraction.listeners.impl.NoopMetricsListener;
import com.google.common.base.Strings;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AbstractBatch
extends AbstractPdbBatch
implements Runnable,
PdbBatch {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractBatch.class);
    protected final Logger confidentialLogger;
    public static final int NO_RETRY = 0;
    public static final long DEFAULT_RETRY_INTERVAL = 300L;
    protected static final Marker dev = MarkerFactory.getMarker((String)"DEV");
    protected static final int salt = 100;
    private final Lock bufferLock = new ReentrantLock();
    private final Lock flushTransactionLock = new ReentrantLock();
    protected final DatabaseEngine de;
    protected final long maxAwaitTimeShutdown;
    protected ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    protected final int batchSize;
    protected final long batchTimeout;
    protected int batch;
    protected volatile long lastFlush;
    protected LinkedList<BatchEntry> buffer = new LinkedList();
    protected String name;
    protected BatchListener batchListener;
    private final MetricsListener metricsListener;
    protected final int maxFlushRetries;
    protected final long flushRetryDelay;

    protected AbstractBatch(DatabaseEngine de, BatchConfig<?> config) {
        Objects.requireNonNull(de, "The provided database engine is null.");
        Objects.requireNonNull(config, "The provided config is null.");
        this.de = de;
        this.batch = this.batchSize = config.getBatchSize();
        this.batchTimeout = config.getBatchTimeout().toMillis();
        this.lastFlush = System.currentTimeMillis();
        this.name = config.getName();
        this.maxAwaitTimeShutdown = Optional.ofNullable(config.getMaxAwaitTimeShutdown()).map(Duration::toMillis).orElse(de.getProperties().getMaximumAwaitTimeBatchShutdown());
        this.batchListener = config.getBatchListener();
        this.metricsListener = config.getMetricsListener();
        this.maxFlushRetries = config.getMaxFlushRetries();
        this.flushRetryDelay = config.getFlushRetryDelay().toMillis();
        this.confidentialLogger = config.getConfidentialLogger().orElse(logger);
    }

    @Deprecated
    protected AbstractBatch(DatabaseEngine de, String name, int batchSize, long batchTimeout, long maxAwaitTimeShutdown, @Nullable BatchListener batchListener, int maxFlushRetries, long flushRetryDelay, @Nullable Logger confidentialLogger) {
        Objects.requireNonNull(de, "The provided database engine is null.");
        this.de = de;
        this.batchSize = batchSize;
        this.batch = batchSize;
        this.batchTimeout = batchTimeout;
        this.lastFlush = System.currentTimeMillis();
        this.name = Strings.isNullOrEmpty((String)name) ? "Anonymous Batch" : name;
        this.maxAwaitTimeShutdown = maxAwaitTimeShutdown;
        this.batchListener = Optional.ofNullable(batchListener).orElse(NoopBatchListener.INSTANCE);
        this.metricsListener = NoopMetricsListener.INSTANCE;
        this.maxFlushRetries = maxFlushRetries;
        this.flushRetryDelay = flushRetryDelay;
        this.confidentialLogger = Optional.ofNullable(confidentialLogger).orElse(logger);
    }

    @Deprecated
    protected AbstractBatch(DatabaseEngine de, String name, int batchSize, long batchTimeout, long maxAwaitTimeShutdown, @Nullable BatchListener batchListener, int maxFlushRetries, long flushRetryDelay) {
        this(de, name, batchSize, batchTimeout, maxAwaitTimeShutdown, batchListener, maxFlushRetries, flushRetryDelay, null);
    }

    @Deprecated
    protected AbstractBatch(DatabaseEngine de, String name, int batchSize, long batchTimeout, long maxAwaitTimeShutdown, @Nullable BatchListener batchListener) {
        this(de, name, batchSize, batchTimeout, maxAwaitTimeShutdown, batchListener, 0, 300L);
    }

    @Deprecated
    protected AbstractBatch(DatabaseEngine de, String name, int batchSize, long batchTimeout, long maxAwaitTimeShutdown, FailureListener failureListener, int maxFlushRetries, long flushRetryDelay) {
        this(de, name, batchSize, batchTimeout, maxAwaitTimeShutdown, AbstractBatch.convertToBatchListener(failureListener), maxFlushRetries, flushRetryDelay);
    }

    @Deprecated
    protected AbstractBatch(DatabaseEngine de, String name, int batchSize, long batchTimeout, long maxAwaitTimeShutdown, FailureListener failureListener) {
        this(de, name, batchSize, batchTimeout, maxAwaitTimeShutdown, AbstractBatch.convertToBatchListener(failureListener), 0, 300L);
    }

    @Deprecated
    protected AbstractBatch(DatabaseEngine de, String name, int batchSize, long batchTimeout, long maxAwaitTimeShutdown) {
        this(de, name, batchSize, batchTimeout, maxAwaitTimeShutdown, (BatchListener)null);
    }

    @Deprecated
    protected AbstractBatch(DatabaseEngine de, int batchSize, long batchTimeout, long maxAwaitTimeShutdown) {
        this(de, null, batchSize, batchTimeout, maxAwaitTimeShutdown);
    }

    protected void start() {
        Runnable resilientTask = () -> {
            try {
                this.run();
            }
            catch (Exception e) {
                logger.error("[{}] Error during timeout-initiated flush", (Object)this.name, (Object)e);
            }
        };
        this.scheduler.scheduleAtFixedRate(resilientTask, 0L, this.batchTimeout + 100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws Exception {
        this.destroy();
        this.metricsListener.close();
    }

    public void destroy() {
        logger.trace("{} - Destroy called on Batch", (Object)this.name);
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(this.maxAwaitTimeShutdown, TimeUnit.MILLISECONDS)) {
                logger.warn("Could not terminate batch within {}. Forcing shutdown.", (Object)DurationFormatUtils.formatDurationWords((long)this.maxAwaitTimeShutdown, (boolean)true, (boolean)true));
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.debug("Interrupted while waiting.", (Throwable)e);
        }
        this.flush();
    }

    @Override
    public void add(BatchEntry batchEntry) throws DatabaseEngineException {
        this.bufferLock.lock();
        try {
            this.metricsListener.onEntryAdded();
            this.buffer.add(batchEntry);
            --this.batch;
        }
        finally {
            this.bufferLock.unlock();
        }
        if (this.batch <= 0) {
            this.flush();
        }
    }

    @Override
    public void add(String entityName, EntityEntry ee) throws DatabaseEngineException {
        this.add(new BatchEntry(entityName, ee));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flush() {
        LinkedList<BatchEntry> temp;
        this.metricsListener.onFlushTriggered();
        long flushTriggeredMs = System.currentTimeMillis();
        this.bufferLock.lock();
        try {
            this.lastFlush = System.currentTimeMillis();
            if (this.batch == this.batchSize) {
                this.onFlushFinished(flushTriggeredMs, Collections.emptyList(), Collections.emptyList());
                logger.trace("[{}] Batch empty, not flushing", (Object)this.name);
                return;
            }
            this.batch = this.batchSize;
            temp = this.buffer;
            this.buffer = new LinkedList();
        }
        finally {
            this.bufferLock.unlock();
        }
        long start = System.currentTimeMillis();
        try {
            this.flushTransactionLock.lock();
            this.metricsListener.onFlushStarted(flushTriggeredMs, temp.size());
            start = System.currentTimeMillis();
            this.processBatch(this.de, temp);
            this.onFlushFinished(flushTriggeredMs, temp, Collections.emptyList());
            logger.trace("[{}] Batch flushed. Took {} ms, {} rows.", new Object[]{this.name, System.currentTimeMillis() - start, temp.size()});
            return;
        }
        catch (Exception e) {
            block37: {
                String msg;
                int retryCount;
                if (this.maxFlushRetries > 0) {
                    String msg2 = "[{}] Error occurred while flushing. Retrying.";
                    this.confidentialLogger.warn(dev, "[{}] Error occurred while flushing. Retrying.", (Object)this.name, (Object)e);
                    if (this.confidentialLogger != logger) {
                        logger.warn(dev, "[{}] Error occurred while flushing. Retrying.", (Object)this.name);
                    }
                }
                boolean success = false;
                for (retryCount = 0; retryCount < this.maxFlushRetries && !success; ++retryCount) {
                    try {
                        Thread.sleep(this.flushRetryDelay);
                        if (this.de.checkConnection() && this.de.isTransactionActive()) {
                            this.de.rollback();
                        }
                        this.processBatch(this.de, temp);
                        success = true;
                        continue;
                    }
                    catch (InterruptedException ex) {
                        logger.debug("Interrupted while trying to flush batch. Stopping retries.");
                        Thread.currentThread().interrupt();
                        break;
                    }
                    catch (Exception ex) {
                        msg = "[{}] Error occurred while flushing (retry attempt {}).";
                        this.confidentialLogger.warn(dev, "[{}] Error occurred while flushing (retry attempt {}).", new Object[]{this.name, retryCount + 1, ex});
                        if (this.confidentialLogger == logger) continue;
                        logger.warn(dev, "[{}] Error occurred while flushing (retry attempt {}).", (Object)this.name, (Object)(retryCount + 1));
                    }
                }
                if (success) {
                    this.onFlushFinished(flushTriggeredMs, temp, Collections.emptyList());
                    logger.trace("[{}] Batch flushed. Took {} ms, {} retries, {} rows.", new Object[]{this.name, System.currentTimeMillis() - start, retryCount, temp.size()});
                    return;
                }
                try {
                    if (this.de.isTransactionActive()) {
                        this.de.rollback();
                    }
                }
                catch (Exception ee) {
                    ee.addSuppressed(e);
                    msg = "[{}] Batch failed to check the flush transaction state";
                    this.confidentialLogger.trace("[{}] Batch failed to check the flush transaction state", (Object)this.name, (Object)ee);
                    if (this.confidentialLogger == logger) break block37;
                    logger.trace("[{}] Batch failed to check the flush transaction state", (Object)this.name);
                }
            }
            this.onFlushFinished(flushTriggeredMs, Collections.emptyList(), temp);
            String msg = "[{}] Error occurred while flushing. Aborting batch flush.";
            this.confidentialLogger.error(dev, "[{}] Error occurred while flushing. Aborting batch flush.", (Object)this.name, (Object)e);
            if (this.confidentialLogger == logger) return;
            logger.error(dev, "[{}] Error occurred while flushing. Aborting batch flush.", (Object)this.name);
            return;
        }
        finally {
            try {
                if (this.de.isTransactionActive()) {
                    this.de.rollback();
                }
            }
            catch (Exception e) {
                String msg = "[{}] Batch failed to check the flush transaction state";
                this.confidentialLogger.trace("[{}] Batch failed to check the flush transaction state", (Object)this.name, (Object)e);
                if (this.confidentialLogger != logger) {
                    logger.trace("[{}] Batch failed to check the flush transaction state", (Object)this.name);
                }
            }
            finally {
                this.flushTransactionLock.unlock();
            }
        }
    }

    public void flush(boolean sync) {
        if (!sync) {
            this.flush();
        } else {
            try {
                this.flushTransactionLock.lock();
                this.flush();
            }
            finally {
                this.flushTransactionLock.unlock();
            }
        }
    }

    public void onFlushFailure(BatchEntry[] entries) {
        this.batchListener.onFailure(entries);
    }

    public void onFlushSuccess(BatchEntry[] entries) {
        this.batchListener.onSuccess(entries);
    }

    private void onFlushFinished(long flushTriggeredMs, List<BatchEntry> successfulEntries, List<BatchEntry> failedEntries) {
        long elapsed = System.currentTimeMillis() - flushTriggeredMs;
        this.metricsListener.onFlushFinished(elapsed, successfulEntries.size(), failedEntries.size());
        if (!failedEntries.isEmpty()) {
            this.onFlushFailure(failedEntries.toArray(new BatchEntry[0]));
        }
        if (!successfulEntries.isEmpty()) {
            this.onFlushSuccess(successfulEntries.toArray(new BatchEntry[0]));
        }
    }

    @Override
    public void run() {
        if (System.currentTimeMillis() - this.lastFlush >= this.batchTimeout) {
            logger.trace("[{}] Flush timeout occurred", (Object)this.name);
            this.flush();
        }
    }

    public static BatchListener convertToBatchListener(final FailureListener failureListener) {
        return new NoopBatchListener(){

            @Override
            public void onFailure(BatchEntry[] rowsFailed) {
                failureListener.onFailure(rowsFailed);
            }
        };
    }
}

