/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.batch;

import com.feedzai.commons.sql.abstraction.batch.BatchConfig;
import com.feedzai.commons.sql.abstraction.batch.PdbBatch;
import com.feedzai.commons.sql.abstraction.listeners.BatchListener;
import com.feedzai.commons.sql.abstraction.listeners.MetricsListener;
import com.feedzai.commons.sql.abstraction.listeners.impl.NoopBatchListener;
import com.feedzai.commons.sql.abstraction.listeners.impl.NoopMetricsListener;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class AbstractBatchConfig<PB extends PdbBatch, SELF extends AbstractBatchConfig<PB, SELF>>
implements BatchConfig<PB> {
    public final String defaultBatchName = "Anonymous " + this.getBatchClass().getSimpleName();
    public static final int DEFAULT_BATCH_SIZE = 1000;
    public static final Duration DEFAULT_BATCH_TIMEOUT = Duration.ofSeconds(1L);
    public static final int NO_RETRY = 0;
    public static final Duration DEFAULT_RETRY_INTERVAL = Duration.ofMillis(300L);
    private final String name;
    private final int batchSize;
    private final Duration batchTimeout;
    private final Duration maxAwaitTimeShutdown;
    private final int maxFlushRetries;
    private final Duration flushRetryDelay;
    private final BatchListener batchListener;
    private final MetricsListener metricsListener;
    private final Logger confidentialLogger;

    protected AbstractBatchConfig(Builder<PB, SELF, ?> builder) {
        this.name = (String)StringUtils.defaultIfBlank((CharSequence)builder.name, (CharSequence)this.defaultBatchName);
        this.batchSize = Optional.ofNullable(builder.batchSize).orElse(1000);
        AbstractBatchConfig.checkArgument(this.batchSize > 0, "batchSize must be > 0 (was set to %s)", this.batchSize);
        this.batchTimeout = Optional.ofNullable(builder.batchTimeout).orElse(DEFAULT_BATCH_TIMEOUT);
        AbstractBatchConfig.checkArgument(!this.batchTimeout.isNegative(), "batchTimeout must be >= 0 (was set to %s)", builder.batchTimeout);
        this.maxAwaitTimeShutdown = builder.maxAwaitTimeShutdown;
        Optional.ofNullable(this.getMaxAwaitTimeShutdown()).ifPresent(maxAwaitTimeShutdown -> AbstractBatchConfig.checkArgument(!this.maxAwaitTimeShutdown.isNegative(), "When maxAwaitTimeShutdown is defined it must be >= 0 (was set to %s)", this.maxAwaitTimeShutdown));
        this.maxFlushRetries = Optional.ofNullable(builder.maxFlushRetries).orElse(0);
        AbstractBatchConfig.checkArgument(this.maxFlushRetries >= 0, "maxFlushRetries must be >= 0 (was set to %s)", this.maxFlushRetries);
        this.flushRetryDelay = Optional.ofNullable(builder.flushRetryDelay).orElse(DEFAULT_RETRY_INTERVAL);
        AbstractBatchConfig.checkArgument(!this.flushRetryDelay.isNegative(), "flushRetryDelay must be >= 0 (was set to %s)", this.flushRetryDelay);
        this.batchListener = Optional.ofNullable(builder.batchListener).orElse(NoopBatchListener.INSTANCE);
        this.metricsListener = Optional.ofNullable(builder.metricsListener).orElse(NoopMetricsListener.INSTANCE);
        this.confidentialLogger = builder.confidentialLogger;
    }

    protected static void checkArgument(boolean condition, String errorMessageFormat, Object errorMessageArg) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(errorMessageFormat, errorMessageArg));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public Duration getBatchTimeout() {
        return this.batchTimeout;
    }

    @Override
    public Duration getMaxAwaitTimeShutdown() {
        return this.maxAwaitTimeShutdown;
    }

    @Override
    public int getMaxFlushRetries() {
        return this.maxFlushRetries;
    }

    @Override
    public Duration getFlushRetryDelay() {
        return this.flushRetryDelay;
    }

    @Override
    public BatchListener getBatchListener() {
        return this.batchListener;
    }

    @Override
    public MetricsListener getMetricsListener() {
        return this.metricsListener;
    }

    @Override
    public Optional<Logger> getConfidentialLogger() {
        return Optional.ofNullable(this.confidentialLogger);
    }

    public static abstract class Builder<PB extends PdbBatch, BC extends AbstractBatchConfig<PB, ?>, SELF extends Builder<PB, BC, SELF>> {
        protected String name;
        protected Integer batchSize;
        protected Duration batchTimeout;
        protected Duration maxAwaitTimeShutdown;
        protected Integer maxFlushRetries;
        protected Duration flushRetryDelay;
        protected BatchListener batchListener;
        protected MetricsListener metricsListener;
        protected Logger confidentialLogger;

        public final SELF withName(@Nullable String name) {
            this.name = name;
            return this.self();
        }

        public final SELF withBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this.self();
        }

        public final SELF withBatchTimeout(Duration batchTimeout) {
            this.batchTimeout = batchTimeout;
            return this.self();
        }

        public final SELF withMaxAwaitTimeShutdown(Duration maxAwaitTimeShutdown) {
            this.maxAwaitTimeShutdown = maxAwaitTimeShutdown;
            return this.self();
        }

        public final SELF withMaxFlushRetries(int maxFlushRetries) {
            this.maxFlushRetries = maxFlushRetries;
            return this.self();
        }

        public final SELF withFlushRetryDelay(Duration flushRetryDelay) {
            this.flushRetryDelay = flushRetryDelay;
            return this.self();
        }

        public final SELF withBatchListener(BatchListener batchListener) {
            this.batchListener = batchListener;
            return this.self();
        }

        public final SELF withMetricsListener(MetricsListener metricsListener) {
            this.metricsListener = metricsListener;
            return this.self();
        }

        public final SELF withConfidentialLogger(Logger confidentialLogger) {
            this.confidentialLogger = confidentialLogger;
            return this.self();
        }

        protected abstract SELF self();

        public abstract BC build();
    }
}

