/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.batch;

import com.feedzai.commons.sql.abstraction.batch.BatchEntry;
import com.feedzai.commons.sql.abstraction.batch.PdbBatch;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractPdbBatch
implements PdbBatch {
    @Override
    public void add(String entityName, EntityEntry ee) throws Exception {
        this.add(new BatchEntry(entityName, ee));
    }

    @Override
    public CompletableFuture<Void> flushAsync() {
        CompletableFuture<Void> flushFuture = new CompletableFuture<Void>();
        try {
            this.flush();
            flushFuture.complete(null);
        }
        catch (Exception e) {
            flushFuture.completeExceptionally(e);
        }
        return flushFuture;
    }

    protected void processBatch(DatabaseEngine de, List<BatchEntry> batchEntries) throws DatabaseEngineException {
        de.beginTransaction();
        for (BatchEntry entry : batchEntries) {
            de.addBatch(entry.getTableName(), entry.getEntityEntry());
        }
        de.flush();
        de.commit();
    }
}

