/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class Function
extends Expression {
    public static final String MAX = "MAX";
    public static final String MIN = "MIN";
    public static final String AVG = "AVG";
    public static final String COUNT = "COUNT";
    public static final String STDDEV = "STDDEV";
    public static final String STDDEV_POP = "STDDEV_POP";
    public static final String SUM = "SUM";
    public static final String UPPER = "UPPER";
    public static final String LOWER = "lower";
    public static final String FLOOR = "FLOOR";
    public static final String CEILING = "CEIL";
    public static final String ASCII = "ASCII";
    public static final String CHAR_LENGTH = "CHAR_LENGTH";
    public static final Set<String> FUNCTIONS = new ImmutableSet.Builder().add((Object)"MAX").add((Object)"MIN").add((Object)"AVG").add((Object)"COUNT").add((Object)"STDDEV").add((Object)"STDDEV_POP").add((Object)"SUM").add((Object)"UPPER").add((Object)"lower").add((Object)"FLOOR").add((Object)"CEIL").add((Object)"ASCII").add((Object)"CHAR_LENGTH").build();
    private final String function;
    private final Expression exp;

    public Function(String function) {
        this(function, null);
    }

    public Function(String function, Expression exp) {
        this.function = StringUtils.escapeSql(function);
        this.exp = exp;
    }

    public String getFunction() {
        return this.function;
    }

    public Expression getExp() {
        return this.exp;
    }

    @Override
    public String translate() {
        return this.translator.translate(this);
    }

    public boolean isUDF() {
        return !FUNCTIONS.contains(this.function);
    }
}

