/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.dialect.SqlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Query
extends Expression {
    private final List<Expression> selectColumns = new ArrayList<Expression>();
    private final List<Expression> fromColumns = new ArrayList<Expression>();
    private Expression where = null;
    private final List<Expression> groupbyColumns = new ArrayList<Expression>();
    private Expression having = null;
    private final List<Expression> orderbyColumns = new ArrayList<Expression>();
    private Integer limit = 0;
    private Integer offset = 0;
    private boolean distinct = false;
    private boolean forUpdate = false;

    @Override
    public String translate() {
        return this.translator.translate(this);
    }

    public List<Expression> getSelectColumns() {
        return ImmutableList.copyOf(this.selectColumns);
    }

    public List<Expression> getFromColumns() {
        return ImmutableList.copyOf(this.fromColumns);
    }

    public Expression getWhere() {
        return this.where;
    }

    public List<Expression> getGroupbyColumns() {
        return ImmutableList.copyOf(this.groupbyColumns);
    }

    public Expression getHaving() {
        return this.having;
    }

    public List<Expression> getOrderbyColumns() {
        return ImmutableList.copyOf(this.orderbyColumns);
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public Query distinct() {
        this.distinct = true;
        return this;
    }

    public Query select(Expression ... selectColumns) {
        if (selectColumns == null) {
            return this;
        }
        return this.select(Arrays.asList(selectColumns));
    }

    public Query select(Collection<? extends Expression> selectColumns) {
        this.selectColumns.addAll(selectColumns);
        return this;
    }

    public Query from(Expression ... fromColumns) {
        if (fromColumns == null) {
            return this;
        }
        return this.from(Arrays.asList(fromColumns));
    }

    public Query from(Collection<? extends Expression> fromColumns) {
        if (fromColumns == null) {
            return this;
        }
        this.fromColumns.addAll(fromColumns);
        return this;
    }

    public Query andWhere(Expression where) {
        this.where = this.where == null ? where : SqlBuilder.and(this.where.enclose(), where.enclose());
        return this;
    }

    public Query where(Expression where) {
        this.where = where;
        return this;
    }

    public Query groupby(Expression ... groupbyColumns) {
        if (groupbyColumns == null) {
            return this;
        }
        return this.groupby(Arrays.asList(groupbyColumns));
    }

    public Query groupby(Collection<? extends Expression> groupbyColumns) {
        if (groupbyColumns == null) {
            return this;
        }
        this.groupbyColumns.addAll(groupbyColumns);
        return this;
    }

    public Query having(Expression having) {
        this.having = having;
        return this;
    }

    public Query orderby(Expression ... orderbyColumns) {
        if (orderbyColumns == null) {
            return this;
        }
        return this.orderby(Arrays.asList(orderbyColumns));
    }

    public Query orderby(Collection<? extends Expression> orderbyColumns) {
        if (orderbyColumns == null) {
            return this;
        }
        this.orderbyColumns.addAll(orderbyColumns);
        return this;
    }

    public Query limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Query offset(Integer offset) {
        this.offset = offset;
        if (this.limit <= 0) {
            this.limit = Integer.MAX_VALUE - offset;
        }
        return this;
    }

    public Query forUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
        return this;
    }
}

