/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine;

import com.feedzai.commons.sql.abstraction.ddl.AlterColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DropPrimaryKey;
import com.feedzai.commons.sql.abstraction.ddl.Rename;
import com.feedzai.commons.sql.abstraction.dml.Between;
import com.feedzai.commons.sql.abstraction.dml.Case;
import com.feedzai.commons.sql.abstraction.dml.Cast;
import com.feedzai.commons.sql.abstraction.dml.Coalesce;
import com.feedzai.commons.sql.abstraction.dml.Concat;
import com.feedzai.commons.sql.abstraction.dml.Delete;
import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.Function;
import com.feedzai.commons.sql.abstraction.dml.Join;
import com.feedzai.commons.sql.abstraction.dml.K;
import com.feedzai.commons.sql.abstraction.dml.Literal;
import com.feedzai.commons.sql.abstraction.dml.Modulo;
import com.feedzai.commons.sql.abstraction.dml.Name;
import com.feedzai.commons.sql.abstraction.dml.Query;
import com.feedzai.commons.sql.abstraction.dml.RepeatDelimiter;
import com.feedzai.commons.sql.abstraction.dml.StringAgg;
import com.feedzai.commons.sql.abstraction.dml.Truncate;
import com.feedzai.commons.sql.abstraction.dml.Union;
import com.feedzai.commons.sql.abstraction.dml.Update;
import com.feedzai.commons.sql.abstraction.dml.Values;
import com.feedzai.commons.sql.abstraction.dml.View;
import com.feedzai.commons.sql.abstraction.dml.When;
import com.feedzai.commons.sql.abstraction.dml.With;
import com.feedzai.commons.sql.abstraction.dml.dialect.SqlBuilder;
import com.feedzai.commons.sql.abstraction.dml.functions.SubString;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class AbstractTranslator {
    @Inject
    protected PdbProperties properties;
    @Inject
    protected Injector injector;

    protected void inject(Expression ... objs) {
        for (Expression o : objs) {
            if (o == null) continue;
            this.injector.injectMembers((Object)o);
        }
    }

    protected void inject(Collection<? extends Expression> objs) {
        for (Expression expression : objs) {
            if (expression == null) continue;
            this.injector.injectMembers((Object)expression);
        }
    }

    protected String join(Collection<?> list, String delimiter) {
        return Joiner.on((String)delimiter).join(list);
    }

    public String translate(Name n) {
        String name = n.getName();
        String environment = n.getEnvironment();
        ArrayList<String> res = new ArrayList<String>();
        if (environment != null) {
            res.add(StringUtils.quotize(environment, this.translateEscape()) + "." + (n.isQuote() ? StringUtils.quotize(name, this.translateEscape()) : name));
        } else {
            res.add(n.isQuote() ? StringUtils.quotize(name, this.translateEscape()) : name);
        }
        if (n.getOrdering() != null) {
            res.add(n.getOrdering());
        }
        if (n.isIsNull()) {
            res.add("IS NULL");
        }
        if (n.isIsNotNull()) {
            res.add("IS NOT NULL");
        }
        if (n.isEnclosed()) {
            return "(" + org.apache.commons.lang3.StringUtils.join(res, (String)" ") + ")";
        }
        return org.apache.commons.lang3.StringUtils.join(res, (String)" ");
    }

    public String translate(Between b) {
        Expression and = b.getAnd();
        Expression column = b.getColumn();
        this.inject(and, column);
        String modifier = "BETWEEN";
        if (b.isNot()) {
            modifier = "NOT " + modifier;
        }
        String result = String.format("%s %s %s", column.translate(), modifier, and.translate());
        if (b.isEnclosed()) {
            result = "(" + result + ")";
        }
        return result;
    }

    public String translate(Coalesce c) {
        Expression[] alternative = c.getAlternative();
        Expression exp = c.getExp();
        this.inject(exp);
        Object[] alts = new String[alternative.length];
        int i = 0;
        for (Expression e : alternative) {
            this.inject(e);
            alts[i] = e.translate();
            ++i;
        }
        return String.format("COALESCE(%s, " + Joiner.on((String)", ").join(alts) + ")", exp.translate());
    }

    public String translate(Delete d) {
        Expression table = d.getTable();
        Expression where = d.getWhere();
        this.inject(table, where);
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("DELETE FROM");
        temp.add(table.translate());
        if (where != null) {
            temp.add("WHERE");
            temp.add(where.translate());
        }
        return Joiner.on((String)" ").join(temp);
    }

    public String translate(Join j) {
        String join = j.getJoin();
        Expression joinExpr = j.getJoinExpr();
        Expression joinTable = j.getJoinTable();
        this.inject(joinExpr, joinTable);
        if (joinTable.isAliased()) {
            return String.format("%s %s %s ON (%s)", join, joinTable.translate(), StringUtils.quotize(joinTable.getAlias(), this.translateEscape()), joinExpr.translate());
        }
        return String.format("%s %s ON (%s)", join, joinTable.translate(), joinExpr.translate());
    }

    public String translate(K k) {
        Object o = k.getConstant();
        String result = o != null ? (!k.isQuote() ? o.toString() : (o instanceof String ? StringUtils.singleQuotize(StringUtils.escapeSql((String)o)) : (o instanceof Enum ? StringUtils.singleQuotize(StringUtils.escapeSql(((Enum)o).name())) : (o instanceof Boolean ? ((Boolean)o != false ? this.translateTrue() : this.translateFalse()) : o.toString())))) : "NULL";
        return k.isEnclosed() ? "(" + result + ")" : result;
    }

    public String translate(Literal l) {
        return l.getLiteral().toString();
    }

    public String translate(Truncate t) {
        Expression table = t.getTable();
        this.inject(table);
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("TRUNCATE TABLE");
        temp.add(table.translate());
        return this.join(temp, " ");
    }

    public String translate(Update u) {
        return u.hasFrom() ? this.translateUpdateFrom(u) : this.translateUpdate(u);
    }

    protected String translateUpdate(Update update) {
        Expression table = update.getTable();
        this.inject(table);
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("UPDATE");
        temp.add(table.translate());
        if (table.isAliased()) {
            temp.add(StringUtils.quotize(table.getAlias(), this.translateEscape()));
        }
        temp.add("SET");
        temp.add(this.translateUpdateSetClause(update));
        if (update.hasFrom()) {
            Expression from = update.getFrom();
            this.inject(from);
            temp.add("FROM");
            temp.add(from.translate());
        }
        if (update.hasWhere()) {
            Expression where = update.getWhere();
            this.inject(where);
            temp.add("WHERE");
            temp.add(where.translate());
        }
        return this.join(temp, " ");
    }

    protected String translateUpdateFrom(Update update) {
        Expression table = update.getTable();
        Expression from = update.getFrom();
        Expression where = update.getWhere();
        this.inject(table, from, where);
        ArrayList<String> translate = new ArrayList<String>();
        translate.add("MERGE INTO");
        translate.add(table.translate());
        translate.add("USING");
        translate.add(from.translate());
        translate.add("ON");
        if (!update.hasWhere()) {
            throw new DatabaseEngineRuntimeException("UPDATE FROM WHERE clause not defined.");
        }
        translate.add(where.enclose().translate());
        translate.add("WHEN MATCHED THEN UPDATE SET");
        translate.add(this.translateUpdateSetClause(update));
        return this.join(translate, " ");
    }

    protected String translateUpdateSetClause(Update update) {
        ArrayList<String> setTranslations = new ArrayList<String>();
        for (Expression e : update.getColumns()) {
            this.inject(e);
            setTranslations.add(e.translate());
        }
        return this.join(setTranslations, ", ");
    }

    public String translate(With with) {
        String translation;
        List<ImmutablePair<Name, Expression>> clauses = with.getClauses();
        clauses.forEach(clause -> {
            this.injector.injectMembers(clause.getLeft());
            this.injector.injectMembers(clause.getRight());
        });
        String withStatements = clauses.stream().map(clause -> ((Name)clause.getLeft()).translate() + " AS (" + ((Expression)clause.getRight()).translate() + ")").collect(Collectors.joining(", "));
        Expression then = with.getThen();
        if (then != null) {
            this.inject(then);
            translation = String.format("WITH %s %s", withStatements, then.translate());
        } else {
            translation = String.format("WITH %s", withStatements);
        }
        return with.isEnclosed() ? "(" + translation + ")" : translation;
    }

    public String translate(When when) {
        this.inject(when.condition);
        this.inject(when.action);
        return String.format("WHEN %s THEN %s", when.condition.translate(), when.action.translate());
    }

    public String translate(Case aCase) {
        String elseString = "";
        if (aCase.getFalseAction() != null) {
            this.inject(aCase.getFalseAction());
            elseString = String.format("ELSE %s", aCase.getFalseAction().translate());
        }
        String whens = aCase.whens.stream().peek(xva$0 -> this.inject((Expression)xva$0)).map(When::translate).collect(Collectors.joining(" "));
        return String.format("CASE %s %s END", whens, elseString);
    }

    public abstract String translate(Cast var1);

    public String translate(Union union) {
        List<Expression> expressions = union.getExpressions();
        String delimiter = union.isAll() ? " UNION ALL " : " UNION ";
        this.inject(expressions);
        String translation = expressions.stream().map(Expression::translate).collect(Collectors.joining(delimiter));
        return union.isEnclosed() ? "(" + translation + ")" : translation;
    }

    public String translate(Values values) {
        ArrayList<Values.Row> rows = new ArrayList<Values.Row>(values.getRows());
        String[] aliases = values.getAliases();
        if (aliases == null || aliases.length == 0) {
            throw new DatabaseEngineRuntimeException("Values requires aliases to avoid ambiguous columns names.");
        }
        rows.forEach(row -> {
            List<Expression> expressions = row.getExpressions();
            for (int i = 0; i < expressions.size() && i < aliases.length; ++i) {
                expressions.get(i).alias(aliases[i]);
            }
        });
        List<Expression> rowsWithSelect = rows.stream().map(xva$0 -> SqlBuilder.select(xva$0)).collect(Collectors.toList());
        Union union = this.rowsToUnion(rowsWithSelect);
        if (values.isEnclosed()) {
            union.enclose();
        }
        return this.translate(union);
    }

    public String translate(Values.Row row) {
        this.inject(row.getExpressions());
        String translation = row.getExpressions().stream().map(expression -> {
            String alias = expression.isAliased() ? " AS " + StringUtils.quotize(expression.getAlias()) : "";
            return expression.translate() + alias;
        }).collect(Collectors.joining(", "));
        return row.isEnclosed() ? "(" + translation + ")" : translation;
    }

    protected Union rowsToUnion(List<Expression> rows) {
        ArrayList<Expression> rowsWithSelect = new ArrayList<Expression>(rows);
        while (rowsWithSelect.size() > 2) {
            ArrayList<Expression> newRowsWithSelect = new ArrayList<Expression>();
            for (int i = 1; i < rowsWithSelect.size(); i += 2) {
                Expression left = (Expression)rowsWithSelect.get(i - 1);
                Expression right = (Expression)rowsWithSelect.get(i);
                newRowsWithSelect.add(SqlBuilder.union(left, right).all().enclose());
            }
            if (rowsWithSelect.size() % 2 == 1) {
                newRowsWithSelect.add((Expression)rowsWithSelect.get(rowsWithSelect.size() - 1));
            }
            rowsWithSelect = newRowsWithSelect;
        }
        return SqlBuilder.union(rowsWithSelect).all();
    }

    public String translate(Concat concat) {
        this.inject(concat.getDelimiter());
        this.inject(concat.getExpressions());
        String toConcat = concat.getExpressions().stream().map(Expression::translate).filter(ex -> !ex.equals("NULL")).collect(Collectors.joining(", "));
        String delimiter = concat.getDelimiter().translate();
        return String.format("CONCAT_WS(%s, %s)", delimiter.equals("NULL") ? "''" : delimiter, toConcat);
    }

    public abstract String translateEscape();

    public abstract String translateTrue();

    public abstract String translateFalse();

    public abstract String translate(AlterColumn var1);

    public abstract String translate(DropPrimaryKey var1);

    public abstract String translate(Function var1);

    public String translate(Modulo m) {
        Expression dividend = m.getDividend();
        Expression divisor = m.getDivisor();
        this.inject(dividend, divisor);
        return String.format("MOD(%s, %s)", dividend.translate(), divisor.translate());
    }

    public abstract String translate(Rename var1);

    public abstract String translate(RepeatDelimiter var1);

    public abstract String translate(Query var1);

    public abstract String translate(View var1);

    public abstract String translate(DbColumn var1);

    public abstract String translate(StringAgg var1);

    public String translate(SubString subString) {
        this.inject(subString.getColumn(), subString.getStart(), subString.getLength());
        return new StringJoiner(", ", "SUBSTRING(", ")").add(subString.getColumn().translate()).add(subString.getStart().translate()).add(subString.getLength().translate()).toString();
    }
}

