/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.handler;

import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineTimeoutException;
import com.feedzai.commons.sql.abstraction.exceptions.DatabaseEngineRetryableException;
import com.feedzai.commons.sql.abstraction.exceptions.DatabaseEngineUniqueConstraintViolationException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;

public class QueryExceptionHandler {
    public boolean isTimeoutException(SQLException exception) {
        return exception instanceof SQLTimeoutException;
    }

    public boolean isRetryableException(SQLException exception) {
        return "40001".equals(exception.getSQLState());
    }

    public boolean isUniqueConstraintViolationException(SQLException exception) {
        if (exception instanceof BatchUpdateException) {
            return this.isUniqueConstraintViolationException(exception.getNextException());
        }
        return "23505".equals(exception.getSQLState());
    }

    public DatabaseEngineException handleException(Exception exception, String message) throws DatabaseEngineException {
        if (exception instanceof SQLException) {
            SQLException sqlException = (SQLException)exception;
            if (this.isTimeoutException(sqlException)) {
                throw new DatabaseEngineTimeoutException(message + " [timeout]", sqlException);
            }
            if (this.isRetryableException(sqlException)) {
                throw new DatabaseEngineRetryableException(message + " [retryable]", sqlException);
            }
            if (this.isUniqueConstraintViolationException(sqlException)) {
                throw new DatabaseEngineUniqueConstraintViolationException(message + " [unique_constraint_violation]", sqlException);
            }
        }
        throw new DatabaseEngineException(message, exception);
    }
}

