/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.dialect.SqlBuilder;
import com.feedzai.commons.sql.abstraction.dml.result.H2ResultIterator;
import com.feedzai.commons.sql.abstraction.dml.result.ResultColumn;
import com.feedzai.commons.sql.abstraction.dml.result.ResultIterator;
import com.feedzai.commons.sql.abstraction.engine.AbstractDatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineDriver;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.MappedEntity;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.engine.handler.OperationFault;
import com.feedzai.commons.sql.abstraction.engine.handler.QueryExceptionHandler;
import com.feedzai.commons.sql.abstraction.engine.impl.H2Translator;
import com.feedzai.commons.sql.abstraction.engine.impl.h2.H2QueryExceptionHandler;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class H2Engine
extends AbstractDatabaseEngine {
    private static final int MAX_VARCHAR_LENGTH = 0x100000;
    protected static final String H2_DRIVER = DatabaseEngineDriver.H2.driver();
    public static final String NAME_ALREADY_EXISTS = "42S01";
    public static final String INDEX_ALREADY_EXISTS = "42S11";
    public static final String TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY = "90017";
    public static final String TABLE_OR_VIEW_DOES_NOT_EXIST = "42S02";
    public static final String CONSTRAINT_NAME_ALREADY_EXISTS = "90045";
    public static final String OPTIONAL_FEATURE_NOT_SUPPORTED = "HYC00";
    public static final QueryExceptionHandler H2_QUERY_EXCEPTION_HANDLER = new H2QueryExceptionHandler();
    private static final Pattern AUTO_SERVER_PATTERN = Pattern.compile("AUTO_SERVER=(TRUE|FALSE)", 2);
    private static final Pattern CLOSE_ON_EXIT_PATTERN = Pattern.compile("DB_CLOSE_ON_EXIT=(TRUE|FALSE)", 2);

    public H2Engine(PdbProperties properties) throws DatabaseEngineException {
        super(H2_DRIVER, properties, Dialect.H2);
    }

    @Override
    protected String getFinalJdbcConnection(String jdbc) {
        Matcher autoServerMatcher = AUTO_SERVER_PATTERN.matcher(jdbc);
        Boolean autoServer = null;
        if (autoServerMatcher.find()) {
            autoServer = Boolean.parseBoolean(autoServerMatcher.group(1));
        }
        Matcher closeOnExitMatcher = CLOSE_ON_EXIT_PATTERN.matcher(jdbc);
        Boolean closeOnExit = null;
        if (closeOnExitMatcher.find()) {
            closeOnExit = Boolean.parseBoolean(closeOnExitMatcher.group(1));
        }
        String finalJdbc = jdbc;
        if (autoServer == null && !Boolean.FALSE.equals(closeOnExit)) {
            autoServer = true;
            finalJdbc = finalJdbc.concat(";AUTO_SERVER=TRUE");
        }
        if (closeOnExit == null && !Boolean.TRUE.equals(autoServer)) {
            finalJdbc = finalJdbc.concat(";DB_CLOSE_ON_EXIT=FALSE");
        }
        return finalJdbc;
    }

    @Override
    protected void onConnectionCreated() throws DatabaseEngineException {
        if (this.supportsLegacyMode()) {
            try (PreparedStatement stmt = this.conn.prepareStatement("SET MODE LEGACY");){
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DatabaseEngineException("Error defining the legacy mode in H2", ex);
            }
        }
    }

    private boolean supportsLegacyMode() throws DatabaseEngineException {
        try {
            return this.conn.getMetaData().getDatabaseMajorVersion() == 2;
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Error accessing the database metadata", ex);
        }
    }

    @Override
    public Class<? extends AbstractTranslator> getTranslatorClass() {
        return H2Translator.class;
    }

    @Override
    protected void setPreparedStatementValue(PreparedStatement ps, int index, DbColumn dbColumn, Object value, boolean fromBatch) throws Exception {
        switch (dbColumn.getDbColumnType()) {
            case BLOB: {
                if (value == null) {
                    ps.setNull(index, 2004);
                    break;
                }
                if (value instanceof Serializable) {
                    ps.setBinaryStream(index, new ByteArrayInputStream(this.objectToArray(value)));
                    break;
                }
                throw new DatabaseEngineException("Cannot convert " + value.getClass().getSimpleName() + " to byte[]. BLOB columns only accept byte arrays.");
            }
            case JSON: 
            case CLOB: {
                if (value == null) {
                    ps.setNull(index, 2005);
                    break;
                }
                if (value instanceof String) {
                    StringReader sr = new StringReader((String)value);
                    ps.setCharacterStream(index, sr);
                    break;
                }
                throw new DatabaseEngineException("Cannot convert " + value.getClass().getSimpleName() + " to String. CLOB columns only accept Strings.");
            }
            default: {
                ps.setObject(index, value);
            }
        }
    }

    private DbEntity injectNotNullIfMissing(DbEntity entity) {
        DbEntity.Builder builder = new DbEntity.Builder().name(entity.getName()).addFks(entity.getFks()).pkFields(entity.getPkFields()).addIndexes(entity.getIndexes());
        List<String> pkFields = entity.getPkFields();
        ArrayList<DbColumn> columns = new ArrayList<DbColumn>();
        for (DbColumn c : entity.getColumns()) {
            if (pkFields.contains(c.getName()) && !c.getColumnConstraints().contains((Object)DbColumnConstraint.NOT_NULL)) {
                columns.add(new DbColumn.Builder().name(c.getName()).type(c.getDbColumnType()).size(c.getSize()).addConstraints(c.getColumnConstraints()).addConstraint(DbColumnConstraint.NOT_NULL).autoInc(c.isAutoInc()).defaultValue(c.getDefaultValue()).build());
                continue;
            }
            columns.add(c);
        }
        return builder.addColumn(columns).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTable(DbEntity entity) throws DatabaseEngineException {
        block17: {
            entity = this.injectNotNullIfMissing(entity);
            ArrayList<String> createTable = new ArrayList<String>();
            createTable.add("CREATE TABLE");
            createTable.add(StringUtils.quotize(entity.getName()));
            ArrayList<String> columns = new ArrayList<String>();
            List<String> pkFields = entity.getPkFields();
            for (DbColumn c : entity.getColumns()) {
                ArrayList<String> column = new ArrayList<String>();
                column.add(StringUtils.quotize(c.getName()));
                column.add(this.translateType(c));
                if (pkFields.contains(c.getName()) && !c.getColumnConstraints().contains((Object)DbColumnConstraint.NOT_NULL)) {
                    c.getColumnConstraints().add(DbColumnConstraint.NOT_NULL);
                }
                for (DbColumnConstraint cc : c.getColumnConstraints()) {
                    column.add(cc.translate());
                }
                if (c.isDefaultValueSet()) {
                    column.add("DEFAULT");
                    column.add(this.translate(c.getDefaultValue()));
                }
                columns.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
            }
            createTable.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
            String createTableStatement = org.apache.commons.lang3.StringUtils.join(createTable, (String)" ");
            this.logger.trace(createTableStatement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(createTableStatement);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_ALREADY_EXISTS), ex);
                    break block17;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPrimaryKey(DbEntity entity) throws DatabaseEngineException {
        block15: {
            if (entity.getPkFields().size() == 0) {
                return;
            }
            ArrayList<String> pks = new ArrayList<String>();
            for (String pk : entity.getPkFields()) {
                pks.add(StringUtils.quotize(pk));
            }
            String pkName = StringUtils.md5(String.format("PK_%s", entity.getName()), this.properties.getMaxIdentifierSize());
            ArrayList<String> statement = new ArrayList<String>();
            statement.add("ALTER TABLE");
            statement.add(StringUtils.quotize(entity.getName()));
            statement.add("ADD CONSTRAINT");
            statement.add(StringUtils.quotize(pkName));
            statement.add("PRIMARY KEY");
            statement.add("(" + org.apache.commons.lang3.StringUtils.join(pks, (String)", ") + ")");
            String addPrimaryKey = org.apache.commons.lang3.StringUtils.join(statement, (String)" ");
            this.logger.trace(addPrimaryKey);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(addPrimaryKey);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY) || ex.getSQLState().startsWith(CONSTRAINT_NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' already has a primary key", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.PRIMARY_KEY_ALREADY_EXISTS), ex);
                    break block15;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addIndexes(DbEntity entity) throws DatabaseEngineException {
        List<DbIndex> indexes = entity.getIndexes();
        for (DbIndex index : indexes) {
            ArrayList<String> createIndex = new ArrayList<String>();
            createIndex.add("CREATE");
            if (index.isUnique()) {
                createIndex.add("UNIQUE");
            }
            createIndex.add("INDEX");
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> columnsForName = new ArrayList<String>();
            for (String column : index.getColumns()) {
                columns.add(StringUtils.quotize(column));
                columnsForName.add(column);
            }
            String idxName = StringUtils.md5(String.format("%s_%s_IDX", entity.getName(), org.apache.commons.lang3.StringUtils.join(columnsForName, (String)"_")), this.properties.getMaxIdentifierSize());
            createIndex.add(StringUtils.quotize(idxName));
            createIndex.add("ON");
            createIndex.add(StringUtils.quotize(entity.getName()));
            createIndex.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
            String statement = org.apache.commons.lang3.StringUtils.join(createIndex, (String)" ");
            this.logger.trace(statement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(statement);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(INDEX_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)idxName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.INDEX_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addSequences(DbEntity entity) {
    }

    @Override
    protected MappedEntity createPreparedStatementForInserts(DbEntity entity) throws DatabaseEngineException {
        ArrayList<String> insertInto = new ArrayList<String>();
        insertInto.add("INSERT INTO");
        insertInto.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> insertIntoWithAutoInc = new ArrayList<String>();
        insertIntoWithAutoInc.add("INSERT INTO");
        insertIntoWithAutoInc.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> columnsWithAutoInc = new ArrayList<String>();
        ArrayList<String> valuesWithAutoInc = new ArrayList<String>();
        String columnWithAutoIncName = null;
        for (DbColumn column : entity.getColumns()) {
            columnsWithAutoInc.add(StringUtils.quotize(column.getName()));
            valuesWithAutoInc.add("?");
            if (column.isAutoInc()) {
                columnWithAutoIncName = column.getName();
                continue;
            }
            columns.add(StringUtils.quotize(column.getName()));
            values.add("?");
        }
        insertInto.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
        insertInto.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(values, (String)", ") + ")");
        insertIntoWithAutoInc.add("(" + org.apache.commons.lang3.StringUtils.join(columnsWithAutoInc, (String)", ") + ")");
        insertIntoWithAutoInc.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(valuesWithAutoInc, (String)", ") + ")");
        String statement = org.apache.commons.lang3.StringUtils.join(insertInto, (String)" ");
        String insertReturnStatement = "";
        String statementWithAutoInt = org.apache.commons.lang3.StringUtils.join(insertIntoWithAutoInc, (String)" ");
        this.logger.trace(statement);
        try {
            int generateKeys = columnWithAutoIncName != null ? 1 : 2;
            PreparedStatement ps = this.conn.prepareStatement(statement, generateKeys);
            PreparedStatement psReturn = this.conn.prepareStatement("", generateKeys);
            PreparedStatement psWithAutoInc = this.conn.prepareStatement(statementWithAutoInt, generateKeys);
            return new MappedEntity().setInsert(ps).setInsertReturning(psReturn).setInsertWithAutoInc(psWithAutoInc).setAutoIncColumn(columnWithAutoIncName);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    @Override
    protected void dropSequences(DbEntity entity) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTable(DbEntity entity) throws DatabaseEngineException {
        block13: {
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                String query = String.format("DROP TABLE %s CASCADE", StringUtils.quotize(entity.getName()));
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(TABLE_OR_VIEW_DOES_NOT_EXIST)) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_DOES_NOT_EXIST), ex);
                    break block13;
                }
                throw new DatabaseEngineException("Error dropping table", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropColumn(DbEntity entity, String ... columns) throws DatabaseEngineException {
        block14: {
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                for (String column : columns) {
                    String query = String.format("ALTER TABLE %s DROP COLUMN %s", StringUtils.quotize(entity.getName()), StringUtils.quotize(column));
                    this.logger.trace(query);
                    drop.executeUpdate(query);
                }
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(TABLE_OR_VIEW_DOES_NOT_EXIST)) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.COLUMN_DOES_NOT_EXIST), ex);
                    break block14;
                }
                throw new DatabaseEngineException("Error dropping column", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addColumn(DbEntity entity, DbColumn ... columns) throws DatabaseEngineException {
        Statement s = null;
        try {
            s = this.conn.createStatement();
            for (DbColumn c : columns) {
                ArrayList<String> column = new ArrayList<String>();
                column.add(StringUtils.quotize(c.getName()));
                column.add(this.translateType(c));
                for (DbColumnConstraint cc : c.getColumnConstraints()) {
                    column.add(cc.translate());
                }
                if (c.isDefaultValueSet()) {
                    column.add("DEFAULT");
                    column.add(this.translate(c.getDefaultValue()));
                }
                String query = String.format("ALTER TABLE %s ADD COLUMN %s", StringUtils.quotize(entity.getName()), org.apache.commons.lang3.StringUtils.join(column, (String)" "));
                this.logger.trace(query);
                s.executeUpdate(query);
            }
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected PreparedStatement getPreparedStatementForPersist(boolean useAutoInc, MappedEntity mappedEntity) {
        return useAutoInc ? mappedEntity.getInsert() : mappedEntity.getInsertWithAutoInc();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected synchronized long doPersist(PreparedStatement ps, MappedEntity me, boolean useAutoInc, int lastBindPosition) throws Exception {
        ps.execute();
        long generatedKey = 0L;
        String autoIncColumnName = me.getAutoIncColumn();
        if (autoIncColumnName == null) return generatedKey;
        if (useAutoInc) {
            try (ResultSet generatedKeys = ps.getGeneratedKeys();){
                if (!generatedKeys.next()) return generatedKey;
                generatedKey = generatedKeys.getLong(autoIncColumnName);
                return generatedKey;
            }
        } else {
            List<Map<String, ResultColumn>> q = this.query(SqlBuilder.select(SqlBuilder.max(SqlBuilder.column(me.getAutoIncColumn()))).from(SqlBuilder.table(me.getEntity().getName())));
            if (!q.isEmpty()) {
                generatedKey = q.get(0).values().iterator().next().toLong();
            }
            this.updatePersistAutoIncSequence(me, generatedKey);
        }
        return generatedKey;
    }

    private void updatePersistAutoIncSequence(MappedEntity mappedEntity, long currentAutoIncVal) {
        this.executeUpdateSilently(String.format("ALTER TABLE %s ALTER COLUMN %s RESTART WITH %d", StringUtils.quotize(mappedEntity.getEntity().getName()), StringUtils.quotize(mappedEntity.getAutoIncColumn()), currentAutoIncVal + 1L));
    }

    @Override
    public boolean isStringAggDistinctCapable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addFks(DbEntity entity, Set<DbFk> fks) throws DatabaseEngineException {
        for (DbFk fk : fks) {
            ArrayList<String> quotizedLocalColumns = new ArrayList<String>();
            for (String string : fk.getLocalColumns()) {
                quotizedLocalColumns.add(StringUtils.quotize(string));
            }
            ArrayList<String> quotizedForeignColumns = new ArrayList<String>();
            for (String s3 : fk.getReferencedColumns()) {
                quotizedForeignColumns.add(StringUtils.quotize(s3));
            }
            String string = StringUtils.quotize(entity.getName());
            String quotizedLocalColumnsSting = org.apache.commons.lang3.StringUtils.join(quotizedLocalColumns, (String)", ");
            String quotizedForeignColumnsString = org.apache.commons.lang3.StringUtils.join(quotizedForeignColumns, (String)", ");
            String alterTable = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", string, StringUtils.quotize(StringUtils.md5("FK_" + string + quotizedLocalColumnsSting + quotizedForeignColumnsString, this.properties.getMaxIdentifierSize())), quotizedLocalColumnsSting, StringUtils.quotize(fk.getReferencedTable()), quotizedForeignColumnsString);
            Statement alterTableStmt = null;
            try {
                alterTableStmt = this.conn.createStatement();
                this.logger.trace(alterTable);
                alterTableStmt.executeUpdate(alterTable);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().equals(CONSTRAINT_NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "Foreign key for table '{}' already exists. Error code: {}.", (Object)entity.getName(), (Object)ex.getSQLState());
                    continue;
                }
                throw new DatabaseEngineException(String.format("Could not add Foreign Key to entity %s. Error code: %s.", entity.getName(), ex.getSQLState()), ex);
            }
            finally {
                try {
                    if (alterTableStmt == null) continue;
                    alterTableStmt.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getSchema() throws DatabaseEngineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void setSchema(String schema) throws DatabaseEngineException {
        try {
            this.conn.setSchema(schema);
        }
        catch (Exception ex) {
            if (ex instanceof SQLException && OPTIONAL_FEATURE_NOT_SUPPORTED.equals(((SQLException)ex).getSQLState())) {
                try (Statement stmt = this.conn.createStatement();){
                    stmt.execute("SET SCHEMA " + StringUtils.quotize(schema));
                    return;
                }
                catch (Exception queryEx) {
                    throw new DatabaseEngineException(String.format("Could not set current schema to '%s'", schema), queryEx);
                }
            }
            throw new DatabaseEngineException(String.format("Could not set current schema to '%s'", schema), ex);
        }
    }

    @Override
    protected ResultIterator createResultIterator(Statement statement, String sql) throws DatabaseEngineException {
        return new H2ResultIterator(statement, sql);
    }

    @Override
    protected ResultIterator createResultIterator(PreparedStatement ps) throws DatabaseEngineException {
        return new H2ResultIterator(ps);
    }

    @Override
    protected QueryExceptionHandler getQueryExceptionHandler() {
        return H2_QUERY_EXCEPTION_HANDLER;
    }

    @Override
    protected void setParameterValues(PreparedStatement ps, int index, Object param) throws SQLException {
        if (param instanceof String) {
            String paramStr = (String)param;
            if (paramStr.length() > 0x100000) {
                ps.setCharacterStream(index, new StringReader(paramStr));
            } else {
                super.setParameterValues(ps, index, param);
            }
        } else if (param instanceof byte[]) {
            ps.setBinaryStream(index, new ByteArrayInputStream((byte[])param));
        } else {
            super.setParameterValues(ps, index, param);
        }
    }
}

