/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.pool;

import com.feedzai.commons.sql.abstraction.engine.DatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.engine.pool.PooledDatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.pool.PooledDatabaseEngineFactory;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseEnginePool
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseEnginePool.class);
    private final GenericObjectPool<PooledDatabaseEngine> pool;
    private final String poolName;
    private final String poolJdbc;
    private final int maxTotal;

    private DatabaseEnginePool(Map<String, String> properties, Consumer<DatabaseEngine> engineModifier) {
        Map<String, List<Map.Entry>> poolEntriesGroupedByPrefix = properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("pool.generic.") || ((String)entry.getKey()).startsWith("pool.abandoned.")).collect(Collectors.groupingBy(entry -> ((String)entry.getKey()).split("\\.")[1]));
        List<Map.Entry<String, String>> genericProps = poolEntriesGroupedByPrefix.get("generic");
        GenericObjectPoolConfig genericConfig = genericProps == null ? new GenericObjectPoolConfig() : this.applyPrefixedConfig("pool.generic.", genericProps, new GenericObjectPoolConfig());
        List<Map.Entry<String, String>> abandonedProps = poolEntriesGroupedByPrefix.get("abandoned");
        AbandonedConfig abandonedConfig = abandonedProps == null ? null : this.applyPrefixedConfig("pool.abandoned.", abandonedProps, new AbandonedConfig());
        PooledDatabaseEngineFactory factory = new PooledDatabaseEngineFactory(properties, engineModifier);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory, genericConfig, abandonedConfig);
        this.poolName = ((Object)((Object)factory)).getClass().getSimpleName().replace("Factory", "Pool");
        this.poolJdbc = properties.get("pdb.jdbc");
        this.maxTotal = genericConfig.getMaxTotal();
        LOGGER.info("'{}' has max size of {}", (Object)this.poolName, (Object)this.maxTotal);
        factory.setPool(this.pool);
    }

    private <T> T applyPrefixedConfig(String prefix, List<Map.Entry<String, String>> properties, T configObj) {
        properties.stream().filter(entry -> ((String)entry.getKey()).startsWith(prefix)).forEach(entry -> {
            String configurationName = (String)entry.getKey();
            try {
                BeanUtils.setProperty((Object)configObj, (String)StringUtils.removeStart((String)configurationName, (String)prefix), entry.getValue());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.error("Invalid configuration '{}'", (Object)configurationName, (Object)e);
            }
        });
        return configObj;
    }

    public DatabaseEngine borrow() {
        return this.borrow(this.pool.getMaxWaitMillis());
    }

    public DatabaseEngine borrow(long borrowMaxWaitMillis) {
        this.logStats();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("'{}' - Waiting {}ms for borrowing a connection.", (Object)this.poolName, (Object)borrowMaxWaitMillis);
        }
        try {
            long startTime = System.nanoTime();
            PooledDatabaseEngine pooledDb = (PooledDatabaseEngine)this.pool.borrowObject(borrowMaxWaitMillis);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("'{}' - Took {}ms to get a database engine.", (Object)this.poolName, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
            }
            return pooledDb;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void logStats() {
        int numActive = this.pool.getNumActive();
        if (numActive == this.maxTotal) {
            LOGGER.warn("'{}' - WARNING: There isn't more connections on the pool. The application will be blocked and it may perform poorly. You may consider to increase the pool size, if this is a common occurrence.", (Object)this.poolName);
            LOGGER.warn("'{}' - Check the documentation to learn how to do it.", (Object)this.poolName);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{} Active Connections: {}", (Object)this.poolName, (Object)numActive);
            LOGGER.trace("{} Idle Connections: {}", (Object)this.poolName, (Object)this.pool.getNumIdle());
            LOGGER.trace("{} Total Connections: {}", (Object)this.poolName, (Object)this.maxTotal);
        }
    }

    @Override
    public void close() {
        this.pool.close();
    }

    public boolean isClosed() {
        return this.pool.isClosed();
    }

    public String getPoolJdbc() {
        return this.poolJdbc;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getNumActive() {
        return this.pool.getNumActive();
    }

    public String getPoolName() {
        return this.poolName;
    }

    void invalidate(PooledDatabaseEngine engine) throws Exception {
        this.pool.invalidateObject((Object)engine);
    }

    public static DatabaseEnginePool getConnectionPool(Map<String, String> properties, Consumer<DatabaseEngine> engineModifier) {
        return new DatabaseEnginePool(properties, engineModifier);
    }

    public static DatabaseEnginePool getConnectionPool(Map<String, String> properties) {
        return new DatabaseEnginePool(properties, db -> {});
    }

    public static DatabaseEnginePool getConnectionPool(Properties properties, Consumer<DatabaseEngine> engineModifier) {
        return new DatabaseEnginePool((Map<String, String>)Maps.fromProperties((Properties)properties), engineModifier);
    }

    public static DatabaseEnginePool getConnectionPool(Properties properties) {
        return new DatabaseEnginePool((Map<String, String>)Maps.fromProperties((Properties)properties), db -> {});
    }

    public static DatabaseEnginePool getConnectionPool(PdbProperties properties, Consumer<DatabaseEngine> engineModifier) {
        return new DatabaseEnginePool((Map<String, String>)Maps.fromProperties((Properties)properties), engineModifier);
    }

    public static DatabaseEnginePool getConnectionPool(PdbProperties properties) {
        return new DatabaseEnginePool((Map<String, String>)Maps.fromProperties((Properties)properties), db -> {});
    }
}

