/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.batch.impl;

import com.feedzai.commons.sql.abstraction.batch.AbstractBatchConfig;
import com.feedzai.commons.sql.abstraction.batch.impl.MultithreadedBatch;
import java.util.Optional;

public class MultithreadedBatchConfig
extends AbstractBatchConfig<MultithreadedBatch, MultithreadedBatchConfig> {
    public static final int DEFAULT_NUMBER_OF_THREADS = 1;
    public static final int DEFAULT_EXECUTOR_CAPACITY = 1000;
    private final int numberOfThreads;
    private final int executorCapacity;

    protected MultithreadedBatchConfig(MultithreadedBatchConfigBuilder builder) {
        super(builder);
        this.numberOfThreads = Optional.ofNullable(builder.numberOfThreads).orElse(1);
        MultithreadedBatchConfig.checkArgument(this.numberOfThreads > 0, "numberOfThreads must be > 0 (was set to %s)", this.numberOfThreads);
        this.executorCapacity = Optional.ofNullable(builder.executorCapacity).orElse(1000);
        MultithreadedBatchConfig.checkArgument(this.executorCapacity > 0, "executorCapacity must be > 0 (was set to %s)", this.executorCapacity);
    }

    @Override
    public Class<MultithreadedBatch> getBatchClass() {
        return MultithreadedBatch.class;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public int getExecutorCapacity() {
        return this.executorCapacity;
    }

    public static MultithreadedBatchConfigBuilder builder() {
        return new MultithreadedBatchConfigBuilder();
    }

    public static class MultithreadedBatchConfigBuilder
    extends AbstractBatchConfig.Builder<MultithreadedBatch, MultithreadedBatchConfig, MultithreadedBatchConfigBuilder> {
        private Integer numberOfThreads;
        private Integer executorCapacity;

        public MultithreadedBatchConfigBuilder withNumberOfThreads(int numberOfThreads) {
            this.numberOfThreads = numberOfThreads;
            return this.self();
        }

        public MultithreadedBatchConfigBuilder withExecutorCapacity(int executorCapacity) {
            this.executorCapacity = executorCapacity;
            return this.self();
        }

        @Override
        protected MultithreadedBatchConfigBuilder self() {
            return this;
        }

        @Override
        public MultithreadedBatchConfig build() {
            return new MultithreadedBatchConfig(this);
        }
    }
}

