/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Update
extends Expression {
    private final Expression table;
    private final List<Expression> columns = new ArrayList<Expression>();
    private Expression from = null;
    private Expression where = null;

    public Update(Expression table) {
        this.table = table;
    }

    public Update set(Expression ... exps) {
        this.columns.addAll(Arrays.asList(exps));
        return this;
    }

    @Override
    public String translate() {
        return this.translator.translate(this);
    }

    public Expression getTable() {
        return this.table;
    }

    public List<Expression> getColumns() {
        return ImmutableList.copyOf(this.columns);
    }

    public Expression getFrom() {
        return this.from;
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public Expression getWhere() {
        return this.where;
    }

    public boolean hasWhere() {
        return this.where != null;
    }

    public Update set(Collection<? extends Expression> exps) {
        this.columns.addAll(exps);
        return this;
    }

    public Update from(Expression from) {
        this.from = from;
        return this;
    }

    public Update where(Expression where) {
        this.where = where;
        return this;
    }
}

