/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine;

import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedEntity
implements AutoCloseable {
    private static Logger logger = LoggerFactory.getLogger(MappedEntity.class);
    private DbEntity entity = null;
    private PreparedStatement insert = null;
    private PreparedStatement insertWithAutoInc = null;
    private PreparedStatement insertReturning = null;
    private PreparedStatement upsert = null;
    private String autoIncColumn = null;
    private boolean sequenceDirty = true;

    public MappedEntity setEntity(DbEntity entity) {
        this.entity = entity;
        return this;
    }

    public MappedEntity setInsert(PreparedStatement insert) {
        this.closeQuietly(this.insert);
        this.insert = insert;
        return this;
    }

    public DbEntity getEntity() {
        return this.entity;
    }

    public PreparedStatement getInsert() {
        return this.insert;
    }

    public PreparedStatement getInsertReturning() {
        return this.insertReturning;
    }

    public MappedEntity setInsertReturning(PreparedStatement insertReturning) {
        this.closeQuietly(this.insertReturning);
        this.insertReturning = insertReturning;
        return this;
    }

    public PreparedStatement getInsertWithAutoInc() {
        return this.insertWithAutoInc;
    }

    public MappedEntity setInsertWithAutoInc(PreparedStatement insertWithAutoInc) {
        this.closeQuietly(this.insertWithAutoInc);
        this.insertWithAutoInc = insertWithAutoInc;
        return this;
    }

    public PreparedStatement getUpsert() {
        return this.upsert;
    }

    public MappedEntity setUpsert(PreparedStatement upsert) {
        this.closeQuietly(this.upsert);
        this.upsert = upsert;
        return this;
    }

    public String getAutoIncColumn() {
        return this.autoIncColumn;
    }

    public MappedEntity setAutoIncColumn(String autoIncColumn) {
        this.autoIncColumn = autoIncColumn;
        return this;
    }

    public boolean isSequenceDirty() {
        return this.autoIncColumn != null && this.sequenceDirty;
    }

    public void setSequenceDirty(boolean sequenceDirty) {
        this.sequenceDirty = sequenceDirty;
    }

    private void closeQuietly(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                logger.trace("Could not close prepared statement.", (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.closeQuietly(this.insert);
        this.closeQuietly(this.insertWithAutoInc);
        this.closeQuietly(this.insertReturning);
        this.closeQuietly(this.upsert);
    }
}

