/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.dialect.SqlBuilder;
import com.feedzai.commons.sql.abstraction.dml.result.PostgreSqlResultIterator;
import com.feedzai.commons.sql.abstraction.dml.result.ResultColumn;
import com.feedzai.commons.sql.abstraction.dml.result.ResultIterator;
import com.feedzai.commons.sql.abstraction.engine.AbstractDatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.ConnectionResetException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineDriver;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.MappedEntity;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.engine.handler.OperationFault;
import com.feedzai.commons.sql.abstraction.engine.handler.QueryExceptionHandler;
import com.feedzai.commons.sql.abstraction.engine.impl.PostgreSqlTranslator;
import com.feedzai.commons.sql.abstraction.engine.impl.postgresql.PostgresSqlQueryExceptionHandler;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.postgresql.Driver;
import org.postgresql.PGProperty;
import org.postgresql.util.PGobject;

public class PostgreSqlEngine
extends AbstractDatabaseEngine {
    protected static final String POSTGRESQL_DRIVER = DatabaseEngineDriver.POSTGRES.driver();
    public static final String NAME_ALREADY_EXISTS = "42P07";
    public static final String TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY = "42P16";
    public static final String TABLE_OR_VIEW_DOES_NOT_EXIST = "42P01";
    public static final String CONSTRAINT_NAME_ALREADY_EXISTS = "42710";
    private static final String LEGACY_DEFAULT_SSL_MODE = "require";
    public static final QueryExceptionHandler PG_QUERY_EXCEPTION_HANDLER = new PostgresSqlQueryExceptionHandler();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public PostgreSqlEngine(PdbProperties properties) throws DatabaseEngineException {
        this(properties, POSTGRESQL_DRIVER);
    }

    protected PostgreSqlEngine(PdbProperties properties, String driver) throws DatabaseEngineException {
        super(driver, properties, Dialect.POSTGRESQL);
    }

    @Override
    protected void setPreparedStatementValue(PreparedStatement ps, int index, DbColumn dbColumn, Object value, boolean fromBatch) throws Exception {
        switch (dbColumn.getDbColumnType()) {
            case BLOB: {
                ps.setBytes(index, this.objectToArray(value));
                break;
            }
            case CLOB: {
                if (value == null) {
                    ps.setNull(index, 2005);
                    break;
                }
                if (value instanceof String) {
                    ps.setString(index, (String)value);
                    break;
                }
                throw new DatabaseEngineException("Cannot convert " + value.getClass().getSimpleName() + " to String. CLOB columns only accept Strings.");
            }
            case JSON: {
                ps.setObject(index, this.getJSONValue((String)value));
                break;
            }
            default: {
                ps.setObject(index, value);
            }
        }
    }

    @Override
    public synchronized void setParameter(String name, int index, Object param, DbColumnType paramType) throws DatabaseEngineException, ConnectionResetException {
        if (paramType == DbColumnType.JSON) {
            param = this.getJSONValue((String)param);
        }
        super.setParameter(name, index, param);
    }

    @Override
    public boolean isStringAggDistinctCapable() {
        return true;
    }

    private Object getJSONValue(String val) throws DatabaseEngineException {
        try {
            PGobject dataObject = new PGobject();
            dataObject.setType("jsonb");
            dataObject.setValue(val);
            return dataObject;
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Error while mapping variables to database, value = " + val, ex);
        }
    }

    @Override
    protected void createTable(DbEntity entity) throws DatabaseEngineException {
        ArrayList<String> createTable = new ArrayList<String>();
        createTable.add("CREATE TABLE");
        createTable.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> columns = new ArrayList<String>();
        for (DbColumn c : entity.getColumns()) {
            ArrayList<String> column = new ArrayList<String>();
            column.add(StringUtils.quotize(c.getName()));
            column.add(this.translateType(c));
            for (DbColumnConstraint cc : c.getColumnConstraints()) {
                column.add(cc.translate());
            }
            if (c.isDefaultValueSet()) {
                column.add("DEFAULT");
                column.add(this.translate(c.getDefaultValue()));
            }
            columns.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
        }
        createTable.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
        String createTableStatement = org.apache.commons.lang3.StringUtils.join(createTable, (String)" ");
        this.logger.trace(createTableStatement);
        try {
            this.executeUpdateQuery(createTableStatement);
        }
        catch (SQLException ex) {
            if (ex.getSQLState().startsWith(NAME_ALREADY_EXISTS)) {
                this.logger.debug(dev, "'{}' is already defined", (Object)entity.getName());
                this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_ALREADY_EXISTS), ex);
            }
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    @Override
    protected void addPrimaryKey(DbEntity entity) throws DatabaseEngineException {
        if (entity.getPkFields().size() == 0) {
            return;
        }
        ArrayList<String> pks = new ArrayList<String>();
        for (String pk : entity.getPkFields()) {
            pks.add(StringUtils.quotize(pk));
        }
        String pkName = StringUtils.md5(String.format("PK_%s", entity.getName()), this.properties.getMaxIdentifierSize());
        ArrayList<String> statement = new ArrayList<String>();
        statement.add("ALTER TABLE");
        statement.add(StringUtils.quotize(entity.getName()));
        statement.add("ADD CONSTRAINT");
        statement.add(StringUtils.quotize(pkName));
        statement.add("PRIMARY KEY");
        statement.add("(" + org.apache.commons.lang3.StringUtils.join(pks, (String)", ") + ")");
        String addPrimaryKey = org.apache.commons.lang3.StringUtils.join(statement, (String)" ");
        this.logger.trace(addPrimaryKey);
        try {
            this.executeUpdateQuery(addPrimaryKey);
        }
        catch (SQLException ex) {
            if (ex.getSQLState().startsWith(TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY)) {
                this.logger.debug(dev, "'{}' already has a primary key", (Object)entity.getName());
                this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.PRIMARY_KEY_ALREADY_EXISTS), ex);
            }
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    @Override
    protected void addIndexes(DbEntity entity) throws DatabaseEngineException {
        List<DbIndex> indexes = entity.getIndexes();
        for (DbIndex index : indexes) {
            ArrayList<String> createIndex = new ArrayList<String>();
            createIndex.add("CREATE");
            if (index.isUnique()) {
                createIndex.add("UNIQUE");
            }
            createIndex.add("INDEX");
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> columnsForName = new ArrayList<String>();
            for (String column : index.getColumns()) {
                columns.add(StringUtils.quotize(column));
                columnsForName.add(column);
            }
            String idxName = StringUtils.md5(String.format("%s_%s_IDX", entity.getName(), org.apache.commons.lang3.StringUtils.join(columnsForName, (String)"_")), this.properties.getMaxIdentifierSize());
            createIndex.add(StringUtils.quotize(idxName));
            createIndex.add("ON");
            createIndex.add(StringUtils.quotize(entity.getName()));
            createIndex.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
            String statement = org.apache.commons.lang3.StringUtils.join(createIndex, (String)" ");
            this.logger.trace(statement);
            try {
                this.executeUpdateQuery(statement);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)idxName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.INDEX_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
        }
    }

    @Override
    protected void addSequences(DbEntity entity) throws DatabaseEngineException {
    }

    @Override
    protected MappedEntity createPreparedStatementForInserts(DbEntity entity) throws DatabaseEngineException {
        ArrayList<String> insertInto = new ArrayList<String>();
        insertInto.add("INSERT INTO");
        insertInto.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> insertIntoWithAutoInc = new ArrayList<String>();
        insertIntoWithAutoInc.add("INSERT INTO");
        insertIntoWithAutoInc.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> columnsWithAutoInc = new ArrayList<String>();
        ArrayList<String> valuesWithAutoInc = new ArrayList<String>();
        String returning = null;
        for (DbColumn column : entity.getColumns()) {
            columnsWithAutoInc.add(StringUtils.quotize(column.getName()));
            valuesWithAutoInc.add("?");
            if (column.isAutoInc()) {
                returning = column.getName();
                continue;
            }
            columns.add(StringUtils.quotize(column.getName()));
            values.add("?");
        }
        insertInto.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
        insertInto.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(values, (String)", ") + ")");
        insertIntoWithAutoInc.add("(" + org.apache.commons.lang3.StringUtils.join(columnsWithAutoInc, (String)", ") + ")");
        insertIntoWithAutoInc.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(valuesWithAutoInc, (String)", ") + ")");
        ArrayList<String> insertIntoReturn = new ArrayList<String>(insertInto);
        insertIntoReturn.add(String.format("RETURNING %s", returning == null ? "0" : StringUtils.quotize(returning)));
        insertIntoWithAutoInc.add(String.format("RETURNING %s", returning == null ? "0" : StringUtils.quotize(returning)));
        String insertStatement = org.apache.commons.lang3.StringUtils.join(insertInto, (String)" ");
        String insertReturnStatement = org.apache.commons.lang3.StringUtils.join(insertIntoReturn, (String)" ");
        String statementWithAutoInt = org.apache.commons.lang3.StringUtils.join(insertIntoWithAutoInc, (String)" ");
        this.logger.trace(insertStatement);
        this.logger.trace(insertReturnStatement);
        PreparedStatement ps = null;
        PreparedStatement psReturn = null;
        PreparedStatement psWithAutoInc = null;
        try {
            ps = this.conn.prepareStatement(insertStatement);
            psReturn = this.conn.prepareStatement(insertReturnStatement);
            psWithAutoInc = this.conn.prepareStatement(statementWithAutoInt);
            String upsert = this.buildUpsertStatement(entity, columns, values);
            PreparedStatement psUpsert = this.conn.prepareStatement(upsert);
            return new MappedEntity().setInsert(ps).setInsertReturning(psReturn).setInsertWithAutoInc(psWithAutoInc).setUpsert(psUpsert).setAutoIncColumn(returning);
        }
        catch (IllegalArgumentException e) {
            this.logger.info("{} Returning an entity without an UPSERT/MERGE prepared statement.", (Object)e.getMessage());
            return new MappedEntity().setInsert(ps).setInsertReturning(psReturn).setInsertWithAutoInc(psWithAutoInc).setAutoIncColumn(returning);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    private String buildUpsertStatement(DbEntity entity, List<String> columns, List<String> values) {
        if (entity.getPkFields().isEmpty() || columns.isEmpty() || values.isEmpty()) {
            throw new IllegalArgumentException(String.format("The 'INSERT INTO (...) ON CONFLICT DO UPDATE' prepared statement was not created for entity '%s'.", entity.getName()));
        }
        ArrayList<String> insertIntoIgnoring = new ArrayList<String>();
        insertIntoIgnoring.add("INSERT INTO");
        insertIntoIgnoring.add(StringUtils.quotize(entity.getName()));
        insertIntoIgnoring.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
        insertIntoIgnoring.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(values, (String)", ") + ")");
        List primaryKeys = entity.getPkFields().stream().map(StringUtils::quotize).collect(Collectors.toList());
        insertIntoIgnoring.add("ON CONFLICT (" + org.apache.commons.lang3.StringUtils.join(primaryKeys, (String)", ") + ")");
        insertIntoIgnoring.add("DO UPDATE");
        ArrayList<String> columnsWithoutPKs = new ArrayList<String>(columns);
        columnsWithoutPKs.removeAll(primaryKeys);
        String columnsToUpdate = columnsWithoutPKs.stream().map(column -> String.format("%s = EXCLUDED.%s", column, column)).collect(Collectors.joining(", "));
        insertIntoIgnoring.add("SET " + columnsToUpdate);
        return org.apache.commons.lang3.StringUtils.join(insertIntoIgnoring, (String)" ");
    }

    @Override
    protected void dropSequences(DbEntity entity) throws DatabaseEngineException {
    }

    @Override
    protected void dropTable(DbEntity entity) throws DatabaseEngineException {
        String query = String.format("DROP TABLE %s CASCADE", StringUtils.quotize(entity.getName()));
        this.logger.trace(query);
        try {
            this.executeUpdateQuery(query);
        }
        catch (SQLException ex) {
            if (ex.getSQLState().startsWith(TABLE_OR_VIEW_DOES_NOT_EXIST)) {
                this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_DOES_NOT_EXIST), ex);
            }
            throw new DatabaseEngineException("Error dropping table", ex);
        }
    }

    @Override
    protected void dropColumn(DbEntity entity, String ... columns) throws DatabaseEngineException {
        ArrayList<String> removeColumns = new ArrayList<String>();
        removeColumns.add("ALTER TABLE");
        removeColumns.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> cols = new ArrayList<String>();
        for (String col : columns) {
            cols.add("DROP COLUMN " + StringUtils.quotize(col));
        }
        removeColumns.add(org.apache.commons.lang3.StringUtils.join(cols, (String)","));
        String query = org.apache.commons.lang3.StringUtils.join(removeColumns, (String)" ");
        this.logger.trace(query);
        try {
            this.executeUpdateQuery(query);
        }
        catch (SQLException ex) {
            if (ex.getMessage().startsWith(TABLE_OR_VIEW_DOES_NOT_EXIST)) {
                this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
            }
            throw new DatabaseEngineException("Error dropping column", ex);
        }
    }

    @Override
    protected void addColumn(DbEntity entity, DbColumn ... columns) throws DatabaseEngineException {
        ArrayList<String> addColumns = new ArrayList<String>();
        addColumns.add("ALTER TABLE");
        addColumns.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> cols = new ArrayList<String>();
        for (DbColumn c : columns) {
            ArrayList<String> column = new ArrayList<String>();
            column.add("ADD COLUMN");
            column.add(StringUtils.quotize(c.getName()));
            column.add(this.translateType(c));
            for (DbColumnConstraint cc : c.getColumnConstraints()) {
                column.add(cc.translate());
            }
            if (c.isDefaultValueSet()) {
                column.add("DEFAULT");
                column.add(this.translate(c.getDefaultValue()));
            }
            cols.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
        }
        addColumns.add(org.apache.commons.lang3.StringUtils.join(cols, (String)","));
        String addColumnsStatement = org.apache.commons.lang3.StringUtils.join(addColumns, (String)" ");
        this.logger.trace(addColumnsStatement);
        try {
            this.executeUpdateQuery(addColumnsStatement);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    @Override
    public Class<? extends AbstractTranslator> getTranslatorClass() {
        return PostgreSqlTranslator.class;
    }

    @Override
    protected synchronized long doPersist(PreparedStatement ps, MappedEntity me, boolean useAutoInc, int lastBindPosition) throws Exception {
        try (ResultSet generatedKeys = ps.executeQuery();){
            long ret = 0L;
            if (useAutoInc) {
                if (generatedKeys.next()) {
                    ret = generatedKeys.getLong(1);
                }
            } else if (this.hasIdentityColumn(me.getEntity())) {
                List<Map<String, ResultColumn>> q = this.query(SqlBuilder.select(SqlBuilder.max(SqlBuilder.column(me.getAutoIncColumn()))).from(SqlBuilder.table(me.getEntity().getName())));
                if (!q.isEmpty()) {
                    ret = q.get(0).values().iterator().next().toLong();
                }
                this.updatePersistAutoIncSequence(me, ret);
            }
            long l = ret;
            return l;
        }
    }

    protected void updatePersistAutoIncSequence(MappedEntity mappedEntity, long currentAutoIncVal) {
        this.executeUpdateSilently(String.format("ALTER SEQUENCE %s RESTART %d", StringUtils.quotize(mappedEntity.getEntity().getName() + "_" + mappedEntity.getAutoIncColumn() + "_seq"), currentAutoIncVal + 1L));
    }

    @Override
    protected void addFks(DbEntity entity, Set<DbFk> fks) throws DatabaseEngineException {
        for (DbFk fk : fks) {
            ArrayList<String> quotizedLocalColumns = new ArrayList<String>();
            for (String string : fk.getLocalColumns()) {
                quotizedLocalColumns.add(StringUtils.quotize(string));
            }
            ArrayList<String> quotizedForeignColumns = new ArrayList<String>();
            for (String s3 : fk.getReferencedColumns()) {
                quotizedForeignColumns.add(StringUtils.quotize(s3));
            }
            String string = StringUtils.quotize(entity.getName());
            String quotizedLocalColumnsSting = org.apache.commons.lang3.StringUtils.join(quotizedLocalColumns, (String)", ");
            String quotizedForeignColumnsString = org.apache.commons.lang3.StringUtils.join(quotizedForeignColumns, (String)", ");
            String alterTable = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", string, StringUtils.quotize(StringUtils.md5("FK_" + string + quotizedLocalColumnsSting + quotizedForeignColumnsString, this.properties.getMaxIdentifierSize())), quotizedLocalColumnsSting, StringUtils.quotize(fk.getReferencedTable()), quotizedForeignColumnsString);
            this.logger.trace(alterTable);
            try {
                this.executeUpdateQuery(alterTable);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().equals(CONSTRAINT_NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "Foreign key for table '{}' already exists. Error code: {}.", (Object)entity.getName(), (Object)ex.getSQLState());
                    continue;
                }
                throw new DatabaseEngineException(String.format("Could not add Foreign Key to entity %s. Error code: %s.", entity.getName(), ex.getSQLState()), ex);
            }
        }
    }

    @Override
    protected Properties getDBProperties() {
        Properties props = super.getDBProperties();
        int loginTimeout = this.properties.getLoginTimeout();
        props.setProperty(PGProperty.LOGIN_TIMEOUT.getName(), Integer.toString(loginTimeout));
        Properties parsedProps = Driver.parseURL((String)this.properties.getJdbc(), null);
        if (parsedProps != null) {
            boolean sslEnabled;
            boolean bl = sslEnabled = PGProperty.SSL.getBoolean(parsedProps) || "".equals(PGProperty.SSL.get(parsedProps));
            if (sslEnabled && !PGProperty.SSL_MODE.isPresent(parsedProps)) {
                this.logger.trace("SSL enabled without SSL mode specified: \"{}\" will be used by default", (Object)LEGACY_DEFAULT_SSL_MODE);
                PGProperty.SSL_MODE.set(props, LEGACY_DEFAULT_SSL_MODE);
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkConnection(Connection conn) {
        boolean bl;
        int timeout = this.properties.getCheckConnectionTimeout();
        int socketTimeout = conn.getNetworkTimeout();
        try {
            conn.setNetworkTimeout(this.socketTimeoutExecutor, timeout * 1000);
            bl = this.pingConnection(conn);
        }
        catch (Exception ex) {
            boolean bl2;
            try {
                this.logger.debug("It wasn't possible to verify the connection state within the timeout of {} seconds.", (Object)timeout, (Object)ex);
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    conn.setNetworkTimeout(this.socketTimeoutExecutor, socketTimeout);
                    throw throwable;
                }
                catch (Exception ex2) {
                    this.logger.debug("It wasn't possible to reset the connection. Connection might be closed.");
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        this.logger.debug("Error closing the connection.", (Throwable)e);
                    }
                    return false;
                }
            }
            conn.setNetworkTimeout(this.socketTimeoutExecutor, socketTimeout);
            return bl2;
        }
        conn.setNetworkTimeout(this.socketTimeoutExecutor, socketTimeout);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pingConnection(Connection conn) {
        Statement s = null;
        try {
            s = conn.createStatement();
            s.executeQuery("select 1");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.logger.debug("Connection is down.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected void setSchema(String schema) throws DatabaseEngineException {
        boolean isSchemaSet;
        super.setSchema(schema);
        try {
            isSchemaSet = this.conn.getSchema() != null;
        }
        catch (Exception e) {
            throw new DatabaseEngineException(String.format("Could not set current schema to '%s'", schema), e);
        }
        if (!isSchemaSet) {
            throw new DatabaseEngineException(String.format("Schema '%s' doesn't exist", schema));
        }
    }

    @Override
    protected DbColumnType toPdbType(int type, String typeName) {
        DbColumnType pdbType = super.toPdbType(type, typeName);
        if (pdbType == DbColumnType.UNMAPPED && typeName.equals("jsonb")) {
            return DbColumnType.JSON;
        }
        return pdbType;
    }

    @Override
    protected ResultIterator createResultIterator(Statement statement, String sql) throws DatabaseEngineException {
        return new PostgreSqlResultIterator(statement, sql);
    }

    @Override
    protected ResultIterator createResultIterator(PreparedStatement ps) throws DatabaseEngineException {
        return new PostgreSqlResultIterator(ps);
    }

    @Override
    protected QueryExceptionHandler getQueryExceptionHandler() {
        return PG_QUERY_EXCEPTION_HANDLER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateQuery(String query) throws SQLException {
        long startMilliSeconds = System.currentTimeMillis();
        Runnable printLog = () -> {
            long timePassedMin = Duration.ofMillis(System.currentTimeMillis()).minusMillis(startMilliSeconds).toMinutes();
            this.logger.info("Database is still executing for '{}'min a query.\nAre you sure the Database is not blocked due to another query being executed?", (Object)timePassedMin);
            this.logger.trace("The query still being executed for '{}'min is: '{}'.\n", (Object)timePassedMin, (Object)query);
        };
        ScheduledFuture<?> scheduledFutureLog = this.executor.scheduleAtFixedRate(printLog, 5L, 5L, TimeUnit.MINUTES);
        Statement statement = null;
        try {
            statement = this.conn.createStatement();
            int n = statement.executeUpdate(query);
            return n;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
            scheduledFutureLog.cancel(true);
        }
    }
}

