/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.pool;

import com.feedzai.commons.sql.abstraction.FailureListener;
import com.feedzai.commons.sql.abstraction.batch.AbstractBatch;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbEntityType;
import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.result.ResultColumn;
import com.feedzai.commons.sql.abstraction.dml.result.ResultIterator;
import com.feedzai.commons.sql.abstraction.engine.ConnectionResetException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.DuplicateEngineException;
import com.feedzai.commons.sql.abstraction.engine.NameAlreadyExistsException;
import com.feedzai.commons.sql.abstraction.engine.RecoveryException;
import com.feedzai.commons.sql.abstraction.engine.RetryLimitExceededException;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.engine.handler.ExceptionHandler;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import com.feedzai.commons.sql.abstraction.listeners.BatchListener;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PooledDatabaseEngine
implements DatabaseEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledDatabaseEngine.class);
    private final GenericObjectPool<PooledDatabaseEngine> pool;
    private final DatabaseEngine engine;

    PooledDatabaseEngine(GenericObjectPool<PooledDatabaseEngine> pool, DatabaseEngine engine) {
        this.pool = pool;
        this.engine = engine;
    }

    public void closeConnection() {
        this.engine.close();
    }

    @Override
    public void close() {
        try {
            this.pool.returnObject((Object)this);
        }
        catch (Exception e) {
            LOGGER.error("Error returning a pooled database engine.", (Throwable)e);
        }
    }

    @Override
    public void beginTransaction() throws DatabaseEngineRuntimeException {
        this.engine.beginTransaction();
    }

    @Override
    public void addEntity(DbEntity entity) throws DatabaseEngineException {
        this.engine.addEntity(entity);
    }

    @Override
    public void loadEntity(DbEntity entity) throws DatabaseEngineException {
        this.engine.loadEntity(entity);
    }

    @Override
    public void updateEntity(DbEntity entity) throws DatabaseEngineException {
        this.engine.updateEntity(entity);
    }

    @Override
    public DbEntity removeEntity(String name) {
        return this.engine.removeEntity(name);
    }

    @Override
    public boolean containsEntity(String name) {
        return this.engine.containsEntity(name);
    }

    @Override
    public void dropEntity(String entity) throws DatabaseEngineException {
        this.engine.dropEntity(entity);
    }

    @Override
    public void dropEntity(DbEntity entity) throws DatabaseEngineException {
        this.engine.dropEntity(entity);
    }

    @Override
    public Long persist(String name, EntityEntry entry) throws DatabaseEngineException {
        return this.engine.persist(name, entry);
    }

    @Override
    public Long persist(String name, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        return this.engine.persist(name, entry, useAutoInc);
    }

    @Override
    public void flush() throws DatabaseEngineException {
        this.engine.flush();
    }

    @Override
    public void flushUpsert() throws DatabaseEngineException {
        this.engine.flushUpsert();
    }

    @Override
    public void commit() throws DatabaseEngineRuntimeException {
        this.engine.commit();
    }

    @Override
    public void rollback() throws DatabaseEngineRuntimeException {
        this.engine.rollback();
    }

    @Override
    public boolean isTransactionActive() throws DatabaseEngineRuntimeException {
        return this.engine.isTransactionActive();
    }

    @Override
    public int executeUpdate(String query) throws DatabaseEngineException {
        return this.engine.executeUpdate(query);
    }

    @Override
    public int executeUpdate(Expression query) throws DatabaseEngineException {
        return this.engine.executeUpdate(query);
    }

    @Override
    public String translate(Expression query) {
        return this.engine.translate(query);
    }

    @Override
    public Dialect getDialect() {
        return this.engine.getDialect();
    }

    @Override
    public AbstractBatch createBatch(int batchSize, long batchTimeout) {
        return this.engine.createBatch(batchSize, batchTimeout);
    }

    @Override
    public AbstractBatch createBatch(int batchSize, long batchTimeout, String batchName) {
        return this.engine.createBatch(batchSize, batchTimeout, batchName);
    }

    @Override
    public AbstractBatch createBatch(int batchSize, long batchTimeout, String batchName, @Nullable BatchListener batchListener) {
        return this.engine.createBatch(batchSize, batchTimeout, batchName, batchListener);
    }

    @Override
    @Deprecated
    public AbstractBatch createBatch(int batchSize, long batchTimeout, String batchName, FailureListener failureListener) {
        return this.engine.createBatch(batchSize, batchTimeout, batchName, failureListener);
    }

    @Override
    public boolean checkConnection(boolean forceReconnect) {
        return this.engine.checkConnection(forceReconnect);
    }

    @Override
    public boolean checkConnection() {
        return this.engine.checkConnection();
    }

    @Override
    public void addBatch(String name, EntityEntry entry) throws DatabaseEngineException {
        this.engine.addBatch(name, entry);
    }

    @Override
    public void addBatchUpsert(String name, EntityEntry entry) throws DatabaseEngineException {
        this.engine.addBatchUpsert(name, entry);
    }

    @Override
    public List<Map<String, ResultColumn>> query(Expression query) throws DatabaseEngineException {
        return this.engine.query(query);
    }

    @Override
    public List<Map<String, ResultColumn>> query(String query) throws DatabaseEngineException {
        return this.engine.query(query);
    }

    @Override
    public List<Map<String, ResultColumn>> query(Expression query, int readTimeoutOverride) throws DatabaseEngineException {
        return this.engine.query(query, readTimeoutOverride);
    }

    @Override
    public List<Map<String, ResultColumn>> query(String query, int readTimeoutOverride) throws DatabaseEngineException {
        return this.engine.query(query, readTimeoutOverride);
    }

    @Override
    public Map<String, DbEntityType> getEntities() throws DatabaseEngineException {
        return this.engine.getEntities();
    }

    @Override
    public Map<String, DbEntityType> getEntities(String schemaPattern) throws DatabaseEngineException {
        return this.engine.getEntities(schemaPattern);
    }

    @Override
    public Map<String, DbColumnType> getMetadata(String tableNamePattern) throws DatabaseEngineException {
        return this.engine.getMetadata(tableNamePattern);
    }

    @Override
    public Map<String, DbColumnType> getMetadata(String schemaPattern, String tableNamePattern) throws DatabaseEngineException {
        return this.engine.getMetadata(schemaPattern, tableNamePattern);
    }

    @Override
    public Map<String, DbColumnType> getQueryMetadata(Expression query) throws DatabaseEngineException {
        return this.engine.getQueryMetadata(query);
    }

    @Override
    public Map<String, DbColumnType> getQueryMetadata(String query) throws DatabaseEngineException {
        return this.engine.getQueryMetadata(query);
    }

    @Override
    public DatabaseEngine duplicate(Properties mergeProperties, boolean copyEntities) throws DuplicateEngineException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PdbProperties getProperties() {
        return this.engine.getProperties();
    }

    @Override
    public void createPreparedStatement(String name, Expression query) throws NameAlreadyExistsException, DatabaseEngineException {
        this.engine.createPreparedStatement(name, query);
    }

    @Override
    public void createPreparedStatement(String name, String query) throws NameAlreadyExistsException, DatabaseEngineException {
        this.engine.createPreparedStatement(name, query);
    }

    @Override
    public void createPreparedStatement(String name, Expression query, int timeout) throws NameAlreadyExistsException, DatabaseEngineException {
        this.engine.createPreparedStatement(name, query, timeout);
    }

    @Override
    public void createPreparedStatement(String name, String query, int timeout) throws NameAlreadyExistsException, DatabaseEngineException {
        this.engine.createPreparedStatement(name, query, timeout);
    }

    @Override
    public void removePreparedStatement(String name) {
        this.engine.removePreparedStatement(name);
    }

    @Override
    public List<Map<String, ResultColumn>> getPSResultSet(String name) throws DatabaseEngineException, ConnectionResetException {
        return this.engine.getPSResultSet(name);
    }

    @Override
    public void setParameters(String name, Object ... params) throws DatabaseEngineException, ConnectionResetException {
        this.engine.setParameters(name, params);
    }

    @Override
    public void setParameter(String name, int index, Object param) throws DatabaseEngineException, ConnectionResetException {
        this.engine.setParameter(name, index, param);
    }

    @Override
    public void setParameter(String name, int index, Object param, DbColumnType paramType) throws DatabaseEngineException, ConnectionResetException {
        this.engine.setParameter(name, index, param, paramType);
    }

    @Override
    public void executePS(String name) throws DatabaseEngineException, ConnectionResetException {
        this.engine.executePS(name);
    }

    @Override
    public void clearParameters(String name) throws DatabaseEngineException, ConnectionResetException {
        this.engine.clearParameters(name);
    }

    @Override
    public boolean preparedStatementExists(String name) {
        return this.engine.preparedStatementExists(name);
    }

    @Override
    public Integer executePSUpdate(String name) throws DatabaseEngineException, ConnectionResetException {
        return this.engine.executePSUpdate(name);
    }

    @Override
    public String commentCharacter() {
        return this.engine.commentCharacter();
    }

    @Override
    public String escapeCharacter() {
        return this.engine.escapeCharacter();
    }

    @Override
    public Connection getConnection() throws RetryLimitExceededException, InterruptedException, RecoveryException {
        return this.engine.getConnection();
    }

    @Override
    public ResultIterator iterator(String query) throws DatabaseEngineException {
        return this.engine.iterator(query);
    }

    @Override
    public ResultIterator iterator(Expression query) throws DatabaseEngineException {
        return this.engine.iterator(query);
    }

    @Override
    public ResultIterator iterator(String query, int fetchSize) throws DatabaseEngineException {
        return this.engine.iterator(query, fetchSize);
    }

    @Override
    public ResultIterator iterator(Expression query, int fetchSize) throws DatabaseEngineException {
        return this.engine.iterator(query, fetchSize);
    }

    @Override
    public ResultIterator iterator(String query, int fetchSize, int readTimeoutOverride) throws DatabaseEngineException {
        return this.engine.iterator(query, fetchSize, readTimeoutOverride);
    }

    @Override
    public ResultIterator iterator(Expression query, int fetchSize, int readTimeoutOverride) throws DatabaseEngineException {
        return this.engine.iterator(query, fetchSize, readTimeoutOverride);
    }

    @Override
    public ResultIterator getPSIterator(String name) throws DatabaseEngineException, ConnectionResetException {
        return this.engine.getPSIterator(name);
    }

    @Override
    public ResultIterator getPSIterator(String name, int fetchSize) throws DatabaseEngineException, ConnectionResetException {
        return this.engine.getPSIterator(name, fetchSize);
    }

    @Override
    public void setExceptionHandler(ExceptionHandler eh) {
        this.engine.setExceptionHandler(eh);
    }

    @Override
    public boolean isStringAggDistinctCapable() {
        return this.engine.isStringAggDistinctCapable();
    }

    @Override
    public void dropView(String view) throws DatabaseEngineException {
        this.engine.dropView(view);
    }
}

