package com.feingto.cloud.cache;

import java.util.List;
import java.util.Map;

/**
 * 缓存集合接口
 *
 * @author longfei
 */
public interface IDataCache<T> extends ICache {
    /**
     * 根据指定键的集合值
     *
     * @param key 键
     * @return List<T>
     */
    List<T> getList(String key);

    /**
     * 根据指定键的Map值
     *
     * @param key 键
     * @return Map<String, T>
     */
    Map<String, T> getMap(String key);

    /**
     * 同步缓存
     *
     * @return boolean
     */
    boolean sync();
}
