package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.IDataCache;
import com.feingto.cloud.kit.CastUtils;

import java.util.List;
import java.util.Map;

/**
 * 缓存扩展接口默认实现
 *
 * @author longfei
 */
public class DefaultDataCacheProvider<T> extends DefaultCacheProvider implements IDataCache<T> {
    private boolean isLoaded = false;

    @Override
    public List<T> getList(String key) {
        if (!isLoaded) {
            this.sync();
        }

        return CastUtils.cast(data.get(key));
    }

    @Override
    public Map<String, T> getMap(String key) {
        if (!this.isLoaded) {
            this.sync();
        }

        return CastUtils.cast(this.filterExpire(data.get(key), key));
    }

    @Override
    public synchronized boolean sync() {
        isLoaded = true;
        return true;
    }
}
