package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.IListCache;
import com.feingto.cloud.cache.RedisManager;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.Collection;
import java.util.List;

/**
 * Redis List 缓存
 *
 * @author longfei
 */
@SuppressWarnings({"unchecked", "rawtypes"})
public class RedisListProvider<T> implements IListCache<T> {
    private static RedisManager redisManager;

    public RedisListProvider(RedisTemplate template) {
        redisManager = new RedisManager().setTemplate(template);
    }

    @Override
    public T get(String key, long index) {
        return (T) redisManager.getListStore().index(key, index);
    }

    @Override
    public List<T> range(String key, long start, long end) {
        return (List<T>) redisManager.getListStore().range(key, start, end);
    }

    @Override
    public void leftPush(String key, T value) {
        redisManager.getListStore().leftPush(key, value);
    }

    @Override
    public void leftPush(String key, Collection<T> values) {
        redisManager.getListStore().leftPushAll(key, values);
    }

    @Override
    public void push(String key, T value) {
        redisManager.getListStore().rightPush(key, value);
    }

    @Override
    public void push(String key, Collection<T> values) {
        redisManager.getListStore().rightPushAll(key, values);
    }

    @Override
    public void pop(String key) {
        redisManager.getListStore().leftPop(key);
    }

    @Override
    public void rightPop(String key) {
        redisManager.getListStore().rightPop(key);
    }

    @Override
    public void set(String key, long index, T value) {
        redisManager.getListStore().set(key, index, value);
    }

    @Override
    public void remove(String key, T value) {
        this.remove(key, 0, value);
    }

    @Override
    public void remove(String key, long count, T value) {
        redisManager.getListStore().remove(key, count, value);
    }

    @Override
    public void trim(String key, long start, long end) {
        redisManager.getListStore().trim(key, start, end);
    }

    @Override
    public Long size(String key) {
        return redisManager.getListStore().size(key);
    }

    @Override
    public void clear(String key) {
        this.trim(key, 1, 0);
    }
}
