package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.ISetCache;
import com.feingto.cloud.cache.RedisManager;
import lombok.SneakyThrows;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Redis Set 缓存
 *
 * @author longfei
 */
@SuppressWarnings({"unchecked", "rawtypes"})
public class RedisSetProvider<T> implements ISetCache<T> {
    private static RedisManager redisManager;

    public RedisSetProvider(RedisTemplate template) {
        redisManager = new RedisManager().setTemplate(template);
    }

    @Override
    public void add(String key, T value) {
        redisManager.getSetStore().add(key, value);
    }

    @Override
    public void add(String key, Collection<T> values) {
        redisManager.getSetStore().add(key, values);
    }

    @Override
    public void remove(String key, T value) {
        redisManager.getSetStore().remove(key, value);
    }

    @Override
    public Long remove(String key, Collection<T> values) {
        return redisManager.getSetStore().remove(key, values);
    }

    @Override
    public T pop(String key) {
        return (T) redisManager.getSetStore().pop(key);
    }

    @Override
    public List<T> pop(String key, long count) {
        return (List<T>) redisManager.getSetStore().pop(key, count);
    }

    @Override
    public Boolean move(String key, T value, String destKey) {
        return redisManager.getSetStore().move(key, value, destKey);
    }

    @Override
    public Long size(String key) {
        return redisManager.getSetStore().size(key);
    }

    @Override
    public Boolean contains(String key, T value) {
        return redisManager.getSetStore().isMember(key, value);
    }

    @Override
    public Set<T> values(String key) {
        return (Set<T>) redisManager.getSetStore().members(key);
    }

    @Override
    public T randomValue(String key) {
        return (T) redisManager.getSetStore().randomMember(key);
    }

    @Override
    public List<T> randomValues(String key, long count) {
        return (List<T>) redisManager.getSetStore().randomMembers(key, count);
    }

    @Override
    public Set<T> distinctRandomValues(String key, long count) {
        return (Set<T>) redisManager.getSetStore().distinctRandomMembers(key, count);
    }

    @Override
    public Set<T> intersect(String key, String otherKey) {
        return (Set<T>) redisManager.getSetStore().intersect(key, otherKey);
    }

    @Override
    public Set<T> intersect(String key, Collection<String> otherKeys) {
        return (Set<T>) redisManager.getSetStore().intersect(key, otherKeys);
    }

    @Override
    public Set<T> intersect(Collection<String> keys) {
        return (Set<T>) redisManager.getSetStore().intersect(keys);
    }

    @Override
    public Long intersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisManager.getSetStore().intersectAndStore(key, otherKeys, destKey);
    }

    @Override
    public Long intersectAndStore(Collection<String> keys, String destKey) {
        return redisManager.getSetStore().intersectAndStore(keys, destKey);
    }

    @Override
    public Set<T> union(String key, String otherKey) {
        return (Set<T>) redisManager.getSetStore().union(key, otherKey);
    }

    @Override
    public Set<T> union(String key, Collection<String> otherKeys) {
        return (Set<T>) redisManager.getSetStore().union(key, otherKeys);
    }

    @Override
    public Set<T> union(Collection<String> keys) {
        return (Set<T>) redisManager.getSetStore().union(keys);
    }

    @Override
    public Long unionAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisManager.getSetStore().unionAndStore(key, otherKeys, destKey);
    }

    @Override
    public Long unionAndStore(Collection<String> keys, String destKey) {
        return redisManager.getSetStore().unionAndStore(keys, destKey);
    }

    @Override
    public Set<T> difference(String key, String otherKey) {
        return (Set<T>) redisManager.getSetStore().difference(key, otherKey);
    }

    @Override
    public Set<T> difference(String key, Collection<String> otherKeys) {
        return (Set<T>) redisManager.getSetStore().difference(key, otherKeys);
    }

    @Override
    public Set<T> difference(Collection<String> keys) {
        return (Set<T>) redisManager.getSetStore().difference(keys);
    }

    @Override
    public Long differenceAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisManager.getSetStore().differenceAndStore(key, otherKeys, destKey);
    }

    @Override
    public Long differenceAndStore(Collection<String> keys, String destKey) {
        return redisManager.getSetStore().differenceAndStore(keys, destKey);
    }

    @SneakyThrows
    @Override
    public Set<T> scan(String key, String pattern) {
        Set<T> result = new HashSet<>();
        Cursor<T> cursor = (Cursor<T>) redisManager.getSetStore().scan(key,
                ScanOptions.scanOptions()
                        .count(10000)
                        .match(pattern)
                        .build());
        cursor.forEachRemaining(result::add);
        cursor.close();
        return result;
    }

    @Override
    public void clear(String key) {
        this.pop(key, this.size(key));
    }
}
