package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.IZSetCache;
import com.feingto.cloud.cache.RedisManager;
import lombok.SneakyThrows;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/**
 * Redis ZSet 缓存
 *
 * @author longfei
 */
@SuppressWarnings({"unchecked", "rawtypes"})
public class RedisZSetProvider<T> implements IZSetCache<T> {
    private static RedisManager redisManager;

    public RedisZSetProvider(RedisTemplate template) {
        redisManager = new RedisManager().setTemplate(template);
    }

    @Override
    public void add(String key, T value, double score) {
        redisManager.getZSetStore().add(key, value, score);
    }

    @Override
    public void add(String key, Collection<T> values, double score) {
        redisManager.getZSetStore().add(key, values, score);
    }

    @Override
    public Double incrementScore(String key, T value, double delta) {
        return redisManager.getZSetStore().incrementScore(key, value, delta);
    }

    @Override
    public void remove(String key, T value) {
        redisManager.getZSetStore().remove(key, value);
    }

    @Override
    public Long remove(String key, Collection<T> values) {
        return redisManager.getZSetStore().remove(key, values);
    }

    @Override
    public Long rank(String key, T value) {
        return redisManager.getZSetStore().rank(key, value);
    }

    @Override
    public Long reverseRank(String key, T value) {
        return redisManager.getZSetStore().reverseRank(key, value);
    }

    @Override
    public Set<T> range(String key, long start, long end) {
        return (Set<T>) redisManager.getZSetStore().range(key, start, end);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> rangeWithScores(String key, long start, long end) {
        return redisManager.getZSetStore().rangeWithScores(key, start, end);
    }

    @Override
    public Set<T> rangeByScore(String key, double min, double max) {
        return (Set<T>) redisManager.getZSetStore().rangeByScore(key, min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> rangeByScoreWithScores(String key, double min, double max) {
        return redisManager.getZSetStore().rangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<T> rangeByScore(String key, double min, double max, long offset, long count) {
        return (Set<T>) redisManager.getZSetStore().rangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> rangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        return redisManager.getZSetStore().rangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Set<T> reverseRange(String key, long start, long end) {
        return (Set<T>) redisManager.getZSetStore().reverseRange(key, start, end);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> reverseRangeWithScores(String key, long start, long end) {
        return redisManager.getZSetStore().reverseRangeWithScores(key, start, end);
    }

    @Override
    public Set<T> reverseRangeByScore(String key, double min, double max) {
        return (Set<T>) redisManager.getZSetStore().reverseRangeByScore(key, min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> reverseRangeByScoreWithScores(String key, double min, double max) {
        return redisManager.getZSetStore().reverseRangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<T> reverseRangeByScore(String key, double min, double max, long offset, long count) {
        return (Set<T>) redisManager.getZSetStore().reverseRangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> reverseRangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        return redisManager.getZSetStore().reverseRangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Long size(String key) {
        return redisManager.getZSetStore().zCard(key);
    }

    @Override
    public Double score(String key, T value) {
        return redisManager.getZSetStore().score(key, value);
    }

    @Override
    public Long removeRange(String key, long start, long end) {
        return redisManager.getZSetStore().removeRange(key, start, end);
    }

    @Override
    public Long removeRangeByScore(String key, double min, double max) {
        return redisManager.getZSetStore().removeRangeByScore(key, min, max);
    }

    @Override
    public Long unionAndStore(String key, String otherKey, String destKey) {
        return redisManager.getZSetStore().unionAndStore(key, otherKey, destKey);
    }

    @Override
    public Long unionAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisManager.getZSetStore().unionAndStore(key, otherKeys, destKey);
    }

    @Override
    public Long unionAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate) {
        return this.unionAndStore(key, otherKeys, destKey, aggregate, RedisZSetCommands.Weights.fromSetCount(1 + otherKeys.size()));
    }

    @Override
    public Long unionAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        return redisManager.getZSetStore().unionAndStore(key, otherKeys, destKey, aggregate, weights);
    }

    @Override
    public Long intersectAndStore(String key, String otherKey, String destKey) {
        return redisManager.getZSetStore().intersectAndStore(key, otherKey, destKey);
    }

    @Override
    public Long intersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisManager.getZSetStore().intersectAndStore(key, otherKeys, destKey);
    }

    @Override
    public Long intersectAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate) {
        return this.intersectAndStore(key, otherKeys, destKey, aggregate, RedisZSetCommands.Weights.fromSetCount(1 + otherKeys.size()));
    }

    @Override
    public Long intersectAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        return redisManager.getZSetStore().intersectAndStore(key, otherKeys, destKey, aggregate, weights);
    }

    @SneakyThrows
    @Override
    public Set<T> scan(String key, String pattern) {
        Set<T> result = new HashSet<>();
        Cursor<T> cursor = (Cursor<T>) redisManager.getZSetStore().scan(key,
                ScanOptions.scanOptions()
                        .count(10000)
                        .match(pattern)
                        .build());
        cursor.forEachRemaining(result::add);
        cursor.close();
        return result;
    }

    @Override
    public void clear(String key) {
        this.removeRange(key, 0, -1);
    }
}
