package com.feingto.cloud.cache.support;

import com.feingto.cloud.cache.ICache;
import com.feingto.cloud.cache.IListCache;
import com.feingto.cloud.cache.ISetCache;
import com.feingto.cloud.cache.IZSetCache;
import com.feingto.cloud.cache.provider.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.client.RestTemplate;

/**
 * 缓存提供配置自动注入
 *
 * @author longfei
 */
@Slf4j
@SuppressWarnings("rawtypes")
@Configurable
public class CacheProviderAutoConfiguration {
    @LoadBalanced
    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        log.info("Load balanced bean '{}' has been injected", RestTemplate.class.getName());
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler(new RestResponseErrorHandler());
        return restTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public ICache redisProvider(RedisTemplate redisTemplate) {
        log.info("Bean '{}' has been injected", RedisProvider.class.getName());
        return new RedisProvider(redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisHashCache redisHashCache(RedisTemplate redisTemplate) {
        log.info("Bean '{}' has been injected", RedisHashCache.class.getName());
        return new RedisHashCache(redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public IListCache redisListProvider(RedisTemplate redisTemplate) {
        log.info("Bean '{}' has been injected", RedisListProvider.class.getName());
        return new RedisListProvider(redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public ISetCache redisSetProvider(RedisTemplate redisTemplate) {
        log.info("Bean '{}' has been injected", RedisSetProvider.class.getName());
        return new RedisSetProvider(redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public IZSetCache redisZSetProvider(RedisTemplate redisTemplate) {
        log.info("Bean '{}' has been injected", RedisZSetProvider.class.getName());
        return new RedisZSetProvider(redisTemplate);
    }
}
