/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.cloud.cache;

import java.io.IOException;
import java.util.function.Consumer;
import org.springframework.data.redis.connection.RedisConnectionCommands;
import org.springframework.data.redis.core.ClusterOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;

public class RedisManager {
    private RedisTemplate<String, Object> template;

    public ValueOperations<String, Object> getValueStore() {
        return this.template.opsForValue();
    }

    public HashOperations<String, String, Object> getHashStore() {
        return this.template.opsForHash();
    }

    public ListOperations<String, Object> getListStore() {
        return this.template.opsForList();
    }

    public SetOperations<String, Object> getSetStore() {
        return this.template.opsForSet();
    }

    public ZSetOperations<String, Object> getZSetStore() {
        return this.template.opsForZSet();
    }

    public ClusterOperations<String, Object> getClusterStore() {
        return this.template.opsForCluster();
    }

    public HyperLogLogOperations<String, Object> getHyperLogLogStore() {
        return this.template.opsForHyperLogLog();
    }

    public String getPing() {
        return (String)this.template.execute(RedisConnectionCommands::ping);
    }

    public void scan(String pattern, Consumer<byte[]> consumer) {
        this.template.execute(connection -> {
            Cursor cursor = connection.scan(ScanOptions.scanOptions().count(10000L).match(pattern).build());
            cursor.forEachRemaining(consumer);
            try {
                cursor.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    public RedisTemplate<String, Object> getTemplate() {
        return this.template;
    }

    public RedisManager setTemplate(RedisTemplate<String, Object> template) {
        this.template = template;
        return this;
    }
}

