/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.ICache;
import com.feingto.cloud.kit.CastUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class DefaultCacheProvider
implements ICache {
    protected Map<String, Object> data = new HashMap<String, Object>();
    private final Map<String, Long> expires = new HashMap<String, Long>();
    private final Map<String, Long> lasts = new HashMap<String, Long>();

    protected Object filterExpire(Object obj, String key) {
        return Optional.ofNullable(obj).filter(v -> this.expires.get(key) != null).filter(v -> this.lasts.get(key) != null).filter(v -> this.expires.get(key) > 0L).filter(v -> System.currentTimeMillis() - this.lasts.get(key) > this.expires.get(key)).map(v -> {
            v = null;
            this.remove(key);
            return v;
        }).orElse(obj);
    }

    @Override
    public <T> Map<String, T> get() {
        return (Map)CastUtils.cast(this.data);
    }

    @Override
    public <T> T get(String key) {
        return (T)CastUtils.cast((Object)this.filterExpire(this.data.get(key), key));
    }

    @Override
    public <T> Map<String, T> match(String pattern) {
        return this.scan(pattern).stream().collect(Collectors.toMap(key -> key, this::get));
    }

    @Override
    public void put(String key, Object value) {
        this.put(key, value, -1L);
    }

    @Override
    public void put(String key, Object value, long expireTime) {
        this.data.put(key, value);
        this.expires.put(key, expireTime);
        this.lasts.put(key, System.currentTimeMillis());
    }

    @Override
    public void put(String key, Object value, long expireTime, TimeUnit timeUnit) {
        switch (timeUnit) {
            case DAYS: {
                expireTime *= 1000000000000L;
                break;
            }
            case HOURS: {
                expireTime *= 1000000000L;
                break;
            }
            case MINUTES: {
                expireTime *= 1000000L;
                break;
            }
            case SECONDS: {
                expireTime *= 1000L;
                break;
            }
            case MILLISECONDS: {
                break;
            }
            case MICROSECONDS: {
                expireTime = (long)((double)expireTime * 0.001);
                break;
            }
            case NANOSECONDS: {
                expireTime *= 0L;
            }
        }
        this.put(key, value, expireTime);
    }

    @Override
    public Set<String> keys() {
        return this.data.keySet();
    }

    @Override
    public Set<String> scan(String pattern) {
        return this.data.keySet().stream().filter(key -> key.startsWith(pattern)).collect(Collectors.toSet());
    }

    @Override
    public boolean has(String key) {
        return this.data.containsKey(key);
    }

    @Override
    public void remove(String key) {
        this.data.remove(key);
        this.expires.remove(key);
        this.lasts.remove(key);
    }

    @Override
    public void removeByPrefix(String prefix) {
        this.keys().stream().filter(key -> key.startsWith(prefix)).forEach(this::remove);
    }

    @Override
    public void clear() {
        this.data.clear();
        this.expires.clear();
        this.lasts.clear();
    }
}

