/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.RedisManager;
import com.feingto.cloud.kit.json.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;

public class RedisHashCache<T> {
    private static RedisManager redisManager;

    public RedisHashCache(RedisTemplate template) {
        redisManager = new RedisManager().setTemplate((RedisTemplate<String, Object>)template);
    }

    public T deserialize(String json) {
        return this.deserialize(json, Object.class);
    }

    public T deserialize(String json, Class<?> clazz) {
        return (T)JSON.json2pojo((String)json, clazz);
    }

    public Map<String, T> get(String key) {
        return this.get(key, Object.class);
    }

    public Map<String, T> get(String key, Class<?> clazz) {
        return Optional.ofNullable(redisManager.getHashStore().getOperations().boundHashOps((Object)key).entries()).map(map -> map.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> this.deserialize((String)entry.getValue(), clazz)))).orElse(new HashMap());
    }

    public T get(String key, String field) {
        return this.get(key, field, Object.class);
    }

    public T get(String key, String field, Class<?> clazz) {
        return this.deserialize((String)redisManager.getHashStore().getOperations().boundHashOps((Object)key).get((Object)field), clazz);
    }

    public List<T> getList(String key, String field, Class<T> clazz) {
        return JSON.json2list((String)((String)redisManager.getHashStore().getOperations().boundHashOps((Object)key).get((Object)field)), clazz);
    }

    public Map<String, T> getMap(String key, String field, Class<T> clazz) {
        return JSON.json2map((String)((String)redisManager.getHashStore().getOperations().boundHashOps((Object)key).get((Object)field)), clazz);
    }

    public Map<String, T> match(String key, String pattern, Class<T> clazz) {
        HashMap result = new HashMap();
        Cursor cursor = redisManager.getHashStore().scan((Object)key, ScanOptions.scanOptions().count(10000L).match(pattern).build());
        cursor.forEachRemaining(entry -> result.put(entry.getKey(), this.deserialize((String)entry.getValue(), clazz)));
        cursor.close();
        return result;
    }

    public void put(String key, String field, Object value) {
        redisManager.getHashStore().getOperations().boundHashOps((Object)key).put((Object)field, (Object)JSON.obj2json((Object)value));
    }

    public void put(String key, String field, Object value, long expireTime) {
        this.put(key, field, value, expireTime, TimeUnit.MILLISECONDS);
    }

    public void put(String key, String field, Object value, long expireTime, TimeUnit timeUnit) {
        BoundHashOperations operations = redisManager.getHashStore().getOperations().boundHashOps((Object)key);
        operations.put((Object)field, (Object)JSON.obj2json((Object)value));
        operations.expire(expireTime, timeUnit);
    }

    public Set<String> keys(String key) {
        return Optional.ofNullable(redisManager.getHashStore().getOperations().boundHashOps((Object)key).keys()).map(keys -> keys.stream().map(String.class::cast).collect(Collectors.toSet())).orElse(new HashSet());
    }

    public Set<String> scan(String key, String pattern) {
        HashSet<String> result = new HashSet<String>();
        Cursor cursor = redisManager.getHashStore().scan((Object)key, ScanOptions.scanOptions().count(10000L).match(pattern).build());
        cursor.forEachRemaining(entry -> result.add((String)entry.getKey()));
        cursor.close();
        return result;
    }

    public boolean has(String key, String field) {
        return Optional.ofNullable(redisManager.getHashStore().getOperations().boundHashOps((Object)key).hasKey((Object)field)).orElse(false);
    }

    public void remove(String key, String field) {
        redisManager.getHashStore().getOperations().boundHashOps((Object)key).delete(new Object[]{field});
    }

    public void removeByPrefix(String key, String prefix) {
        this.scan(key, prefix.concat("*")).forEach(field -> this.remove(key, (String)field));
    }

    public void clear(String key) {
        redisManager.getHashStore().getOperations().delete((Object)key);
    }
}

