/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.IDataCache;
import com.feingto.cloud.cache.provider.RedisHashCache;
import com.feingto.cloud.kit.reflection.ReflectionKit;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class RedisHashProvider<T>
implements IDataCache<T> {
    private final RedisHashCache<T> redisHashCache;
    private final Class<T> clazz;
    private final String key;

    public RedisHashProvider(RedisTemplate template, String key) {
        this.redisHashCache = new RedisHashCache(template);
        this.clazz = ReflectionKit.getClassGenricType(this.getClass());
        this.key = key;
    }

    @Override
    public Map<String, T> get() {
        return this.redisHashCache.get(this.key);
    }

    @Override
    public T get(String field) {
        return this.redisHashCache.get(this.key, field, this.clazz);
    }

    @Override
    public List<T> getList(String field) {
        return this.redisHashCache.getList(this.key, field, this.clazz);
    }

    @Override
    public Map<String, T> getMap(String key) {
        return this.redisHashCache.getMap(key, key, this.clazz);
    }

    @Override
    public Map<String, T> match(String pattern) {
        return this.redisHashCache.match(this.key, pattern, this.clazz);
    }

    @Override
    public void put(String field, Object value) {
        this.redisHashCache.put(this.key, field, value);
    }

    @Override
    public void put(String field, Object value, long expireTime) {
        this.put(field, value, expireTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public void put(String field, Object value, long expireTime, TimeUnit timeUnit) {
        this.redisHashCache.put(this.key, field, value, expireTime, timeUnit);
    }

    @Override
    public Set<String> keys() {
        return this.redisHashCache.keys(this.key);
    }

    @Override
    public Set<String> scan(String pattern) {
        return this.redisHashCache.scan(this.key, pattern);
    }

    @Override
    public boolean has(String field) {
        return this.redisHashCache.has(this.key, field);
    }

    @Override
    public void remove(String field) {
        this.redisHashCache.remove(this.key, field);
    }

    @Override
    public void removeByPrefix(String prefix) {
        this.redisHashCache.removeByPrefix(this.key, prefix);
    }

    @Override
    public void clear() {
        this.redisHashCache.clear(this.key);
    }

    @Override
    public boolean sync() {
        return false;
    }
}

