/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.IListCache;
import com.feingto.cloud.cache.RedisManager;
import java.util.Collection;
import java.util.List;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisListProvider<T>
implements IListCache<T> {
    private static RedisManager redisManager;

    public RedisListProvider(RedisTemplate template) {
        redisManager = new RedisManager().setTemplate((RedisTemplate<String, Object>)template);
    }

    @Override
    public T get(String key, long index) {
        return (T)redisManager.getListStore().index((Object)key, index);
    }

    @Override
    public List<T> range(String key, long start, long end) {
        return redisManager.getListStore().range((Object)key, start, end);
    }

    @Override
    public void leftPush(String key, T value) {
        redisManager.getListStore().leftPush((Object)key, value);
    }

    @Override
    public void leftPush(String key, Collection<T> values) {
        redisManager.getListStore().leftPushAll((Object)key, new Object[]{values});
    }

    @Override
    public void push(String key, T value) {
        redisManager.getListStore().rightPush((Object)key, value);
    }

    @Override
    public void push(String key, Collection<T> values) {
        redisManager.getListStore().rightPushAll((Object)key, new Object[]{values});
    }

    @Override
    public void pop(String key) {
        redisManager.getListStore().leftPop((Object)key);
    }

    @Override
    public void rightPop(String key) {
        redisManager.getListStore().rightPop((Object)key);
    }

    @Override
    public void set(String key, long index, T value) {
        redisManager.getListStore().set((Object)key, index, value);
    }

    @Override
    public void remove(String key, T value) {
        this.remove(key, 0L, value);
    }

    @Override
    public void remove(String key, long count, T value) {
        redisManager.getListStore().remove((Object)key, count, value);
    }

    @Override
    public void trim(String key, long start, long end) {
        redisManager.getListStore().trim((Object)key, start, end);
    }

    @Override
    public Long size(String key) {
        return redisManager.getListStore().size((Object)key);
    }

    @Override
    public void clear(String key) {
        this.trim(key, 1L, 0L);
    }
}

