/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.cloud.cache.provider;

import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.StringUtils;

public class RedisLock {
    private final ValueOperations<String, String> operations;

    public RedisLock(RedisTemplate<String, String> redisTemplate) {
        this.operations = redisTemplate.opsForValue();
    }

    public boolean lock(String key, String lockValue) {
        return this.lock(key, lockValue, null);
    }

    public boolean lock(String key, String lockValue, Integer lockSeconds) {
        if (lockSeconds != null && this.operations.setIfAbsent((Object)key, (Object)lockValue, (long)lockSeconds.intValue(), TimeUnit.SECONDS).booleanValue()) {
            return true;
        }
        if (lockSeconds == null && this.operations.setIfAbsent((Object)key, (Object)lockValue).booleanValue()) {
            return true;
        }
        String current = (String)this.operations.get((Object)key);
        if (StringUtils.hasText((String)current) && Long.parseLong(current) < System.currentTimeMillis()) {
            String old = (String)this.operations.getAndSet((Object)key, (Object)lockValue);
            return StringUtils.hasText((String)old) && old.equals(current);
        }
        return false;
    }

    public void unlock(String key, String lockValue) {
        try {
            String current = (String)this.operations.get((Object)key);
            if (StringUtils.hasText((String)current) && current.equals(lockValue)) {
                this.operations.getOperations().delete((Object)key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLockValue(long expireTime) {
        return String.valueOf(System.currentTimeMillis() + expireTime * 1000L);
    }
}

