/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.ICache;
import com.feingto.cloud.cache.RedisManager;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisProvider
implements ICache {
    private static RedisManager redisManager;

    public RedisProvider(RedisTemplate template) {
        redisManager = new RedisManager().setTemplate((RedisTemplate<String, Object>)template);
    }

    public Map<String, Object> get() {
        return this.match("*");
    }

    @Override
    public <T> T get(String key) {
        return (T)redisManager.getValueStore().get((Object)key);
    }

    @Override
    public <T> Map<String, T> match(String pattern) {
        return this.scan(pattern).stream().collect(Collectors.toMap(k -> k, this::get));
    }

    @Override
    public void put(String key, Object value) {
        redisManager.getValueStore().set((Object)key, value);
    }

    @Override
    public void put(String key, Object value, long expireTime) {
        this.put(key, value, expireTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public void put(String key, Object value, long expireTime, TimeUnit timeUnit) {
        redisManager.getValueStore().set((Object)key, value, expireTime, timeUnit);
    }

    @Override
    public Set<String> keys() {
        return this.scan("*");
    }

    @Override
    public Set<String> scan(String pattern) {
        HashSet<String> keys = new HashSet<String>();
        redisManager.scan(pattern, item -> {
            String key = new String((byte[])item, StandardCharsets.UTF_8);
            if (DataType.STRING.equals((Object)redisManager.getTemplate().type((Object)key))) {
                keys.add(key);
            }
        });
        return keys;
    }

    @Override
    public boolean has(String key) {
        return redisManager.getTemplate().hasKey((Object)key);
    }

    @Override
    public void remove(String key) {
        redisManager.getTemplate().delete((Object)key);
    }

    @Override
    public void removeByPrefix(String prefix) {
        Optional.ofNullable(this.scan(prefix.concat("*"))).ifPresent(keys -> keys.forEach(this::remove));
    }

    @Override
    public void clear() {
        redisManager.getTemplate().execute(connection -> {
            connection.flushDb();
            return true;
        });
    }
}

