/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.ISetCache;
import com.feingto.cloud.cache.RedisManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;

public class RedisSetProvider<T>
implements ISetCache<T> {
    private static RedisManager redisManager;

    public RedisSetProvider(RedisTemplate template) {
        redisManager = new RedisManager().setTemplate((RedisTemplate<String, Object>)template);
    }

    @Override
    public void add(String key, T value) {
        redisManager.getSetStore().add((Object)key, new Object[]{value});
    }

    @Override
    public void add(String key, Collection<T> values) {
        redisManager.getSetStore().add((Object)key, new Object[]{values});
    }

    @Override
    public void remove(String key, T value) {
        redisManager.getSetStore().remove((Object)key, new Object[]{value});
    }

    @Override
    public Long remove(String key, Collection<T> values) {
        return redisManager.getSetStore().remove((Object)key, new Object[]{values});
    }

    @Override
    public T pop(String key) {
        return (T)redisManager.getSetStore().pop((Object)key);
    }

    @Override
    public List<T> pop(String key, long count) {
        return redisManager.getSetStore().pop((Object)key, count);
    }

    @Override
    public Boolean move(String key, T value, String destKey) {
        return redisManager.getSetStore().move((Object)key, value, (Object)destKey);
    }

    @Override
    public Long size(String key) {
        return redisManager.getSetStore().size((Object)key);
    }

    @Override
    public Boolean contains(String key, T value) {
        return redisManager.getSetStore().isMember((Object)key, value);
    }

    @Override
    public Set<T> values(String key) {
        return redisManager.getSetStore().members((Object)key);
    }

    @Override
    public T randomValue(String key) {
        return (T)redisManager.getSetStore().randomMember((Object)key);
    }

    @Override
    public List<T> randomValues(String key, long count) {
        return redisManager.getSetStore().randomMembers((Object)key, count);
    }

    @Override
    public Set<T> distinctRandomValues(String key, long count) {
        return redisManager.getSetStore().distinctRandomMembers((Object)key, count);
    }

    @Override
    public Set<T> intersect(String key, String otherKey) {
        return redisManager.getSetStore().intersect((Object)key, (Object)otherKey);
    }

    @Override
    public Set<T> intersect(String key, Collection<String> otherKeys) {
        return redisManager.getSetStore().intersect((Object)key, otherKeys);
    }

    @Override
    public Set<T> intersect(Collection<String> keys) {
        return redisManager.getSetStore().intersect(keys);
    }

    @Override
    public Long intersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisManager.getSetStore().intersectAndStore((Object)key, otherKeys, (Object)destKey);
    }

    @Override
    public Long intersectAndStore(Collection<String> keys, String destKey) {
        return redisManager.getSetStore().intersectAndStore(keys, (Object)destKey);
    }

    @Override
    public Set<T> union(String key, String otherKey) {
        return redisManager.getSetStore().union((Object)key, (Object)otherKey);
    }

    @Override
    public Set<T> union(String key, Collection<String> otherKeys) {
        return redisManager.getSetStore().union((Object)key, otherKeys);
    }

    @Override
    public Set<T> union(Collection<String> keys) {
        return redisManager.getSetStore().union(keys);
    }

    @Override
    public Long unionAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisManager.getSetStore().unionAndStore((Object)key, otherKeys, (Object)destKey);
    }

    @Override
    public Long unionAndStore(Collection<String> keys, String destKey) {
        return redisManager.getSetStore().unionAndStore(keys, (Object)destKey);
    }

    @Override
    public Set<T> difference(String key, String otherKey) {
        return redisManager.getSetStore().difference((Object)key, (Object)otherKey);
    }

    @Override
    public Set<T> difference(String key, Collection<String> otherKeys) {
        return redisManager.getSetStore().difference((Object)key, otherKeys);
    }

    @Override
    public Set<T> difference(Collection<String> keys) {
        return redisManager.getSetStore().difference(keys);
    }

    @Override
    public Long differenceAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisManager.getSetStore().differenceAndStore((Object)key, otherKeys, (Object)destKey);
    }

    @Override
    public Long differenceAndStore(Collection<String> keys, String destKey) {
        return redisManager.getSetStore().differenceAndStore(keys, (Object)destKey);
    }

    @Override
    public Set<T> scan(String key, String pattern) {
        HashSet result = new HashSet();
        Cursor cursor = redisManager.getSetStore().scan((Object)key, ScanOptions.scanOptions().count(10000L).match(pattern).build());
        cursor.forEachRemaining(result::add);
        cursor.close();
        return result;
    }

    @Override
    public void clear(String key) {
        this.pop(key, this.size(key));
    }
}

