/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.enums.IntervalUnit;
import com.feingto.cloud.cache.provider.RedisHashCache;
import java.util.Optional;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisTokenProvider {
    private static final String CACHE_KEY = "feingto:monitor:control";
    private final RedisHashCache<TokenBucket> redisHashCache;

    public RedisTokenProvider(RedisTemplate redisTemplate) {
        this.redisHashCache = new RedisHashCache(redisTemplate);
    }

    public boolean isLimit(String sign, long limit) {
        return this.isLimit(sign, limit, 1L, IntervalUnit.SECONDS);
    }

    public synchronized boolean isLimit(String sign, long limit, long frequency, IntervalUnit intervalUnit) {
        long frequencyInMills;
        if (limit <= 0L || frequency <= 0L) {
            return false;
        }
        String hashKey = sign;
        switch (intervalUnit) {
            case MILLISECONDS: {
                frequencyInMills = frequency;
                break;
            }
            case SECONDS: {
                frequencyInMills = frequency * 1000L;
                break;
            }
            case MINUTES: {
                frequencyInMills = frequency * 60000L;
                break;
            }
            case HOURS: {
                frequencyInMills = frequency * 360000L;
                break;
            }
            case DAYS: {
                frequencyInMills = frequency * 8640000L;
                break;
            }
            default: {
                return false;
            }
        }
        return Optional.ofNullable(this.redisHashCache.get(CACHE_KEY, hashKey, TokenBucket.class)).map(tokenBucket -> {
            long currentTokensRemaining;
            long lastRefillTime = tokenBucket.lastRefillTime();
            long refillTime = System.currentTimeMillis();
            long intervalSinceLast = refillTime - lastRefillTime;
            if (intervalSinceLast > frequencyInMills) {
                currentTokensRemaining = limit;
            } else {
                double interval = (double)frequencyInMills * 1.0 / (double)limit;
                long grantedTokens = (long)((double)intervalSinceLast / interval);
                currentTokensRemaining = Math.min(grantedTokens + tokenBucket.tokensRemaining(), limit);
            }
            if (currentTokensRemaining == 0L) {
                tokenBucket.tokensRemaining(currentTokensRemaining);
                this.redisHashCache.put(CACHE_KEY, hashKey, tokenBucket);
                return true;
            }
            tokenBucket.lastRefillTime(refillTime);
            tokenBucket.tokensRemaining(currentTokensRemaining - 1L);
            this.redisHashCache.put(CACHE_KEY, hashKey, tokenBucket);
            return false;
        }).orElseGet(() -> {
            this.redisHashCache.put(CACHE_KEY, hashKey, new TokenBucket().lastRefillTime(System.currentTimeMillis()).tokensRemaining(limit - 1L));
            return false;
        });
    }

    public synchronized void reset() {
        this.redisHashCache.clear(CACHE_KEY);
    }

    private static class TokenBucket {
        private long lastRefillTime;
        private long tokensRemaining;

        public long lastRefillTime() {
            return this.lastRefillTime;
        }

        public long tokensRemaining() {
            return this.tokensRemaining;
        }

        public TokenBucket lastRefillTime(long lastRefillTime) {
            this.lastRefillTime = lastRefillTime;
            return this;
        }

        public TokenBucket tokensRemaining(long tokensRemaining) {
            this.tokensRemaining = tokensRemaining;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenBucket)) {
                return false;
            }
            TokenBucket other = (TokenBucket)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.lastRefillTime() != other.lastRefillTime()) {
                return false;
            }
            return this.tokensRemaining() == other.tokensRemaining();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TokenBucket;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $lastRefillTime = this.lastRefillTime();
            result = result * 59 + (int)($lastRefillTime >>> 32 ^ $lastRefillTime);
            long $tokensRemaining = this.tokensRemaining();
            result = result * 59 + (int)($tokensRemaining >>> 32 ^ $tokensRemaining);
            return result;
        }

        public String toString() {
            return "RedisTokenProvider.TokenBucket(lastRefillTime=" + this.lastRefillTime() + ", tokensRemaining=" + this.tokensRemaining() + ")";
        }
    }
}

