/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.IZSetCache;
import com.feingto.cloud.cache.RedisManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;

public class RedisZSetProvider<T>
implements IZSetCache<T> {
    private static RedisManager redisManager;

    public RedisZSetProvider(RedisTemplate template) {
        redisManager = new RedisManager().setTemplate((RedisTemplate<String, Object>)template);
    }

    @Override
    public void add(String key, T value, double score) {
        redisManager.getZSetStore().add((Object)key, value, score);
    }

    @Override
    public void add(String key, Collection<T> values, double score) {
        redisManager.getZSetStore().add((Object)key, values, score);
    }

    @Override
    public Double incrementScore(String key, T value, double delta) {
        return redisManager.getZSetStore().incrementScore((Object)key, value, delta);
    }

    @Override
    public void remove(String key, T value) {
        redisManager.getZSetStore().remove((Object)key, new Object[]{value});
    }

    @Override
    public Long remove(String key, Collection<T> values) {
        return redisManager.getZSetStore().remove((Object)key, new Object[]{values});
    }

    @Override
    public Long rank(String key, T value) {
        return redisManager.getZSetStore().rank((Object)key, value);
    }

    @Override
    public Long reverseRank(String key, T value) {
        return redisManager.getZSetStore().reverseRank((Object)key, value);
    }

    @Override
    public Set<T> range(String key, long start, long end) {
        return redisManager.getZSetStore().range((Object)key, start, end);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> rangeWithScores(String key, long start, long end) {
        return redisManager.getZSetStore().rangeWithScores((Object)key, start, end);
    }

    @Override
    public Set<T> rangeByScore(String key, double min, double max) {
        return redisManager.getZSetStore().rangeByScore((Object)key, min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> rangeByScoreWithScores(String key, double min, double max) {
        return redisManager.getZSetStore().rangeByScoreWithScores((Object)key, min, max);
    }

    @Override
    public Set<T> rangeByScore(String key, double min, double max, long offset, long count) {
        return redisManager.getZSetStore().rangeByScore((Object)key, min, max, offset, count);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> rangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        return redisManager.getZSetStore().rangeByScoreWithScores((Object)key, min, max, offset, count);
    }

    @Override
    public Set<T> reverseRange(String key, long start, long end) {
        return redisManager.getZSetStore().reverseRange((Object)key, start, end);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> reverseRangeWithScores(String key, long start, long end) {
        return redisManager.getZSetStore().reverseRangeWithScores((Object)key, start, end);
    }

    @Override
    public Set<T> reverseRangeByScore(String key, double min, double max) {
        return redisManager.getZSetStore().reverseRangeByScore((Object)key, min, max);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> reverseRangeByScoreWithScores(String key, double min, double max) {
        return redisManager.getZSetStore().reverseRangeByScoreWithScores((Object)key, min, max);
    }

    @Override
    public Set<T> reverseRangeByScore(String key, double min, double max, long offset, long count) {
        return redisManager.getZSetStore().reverseRangeByScore((Object)key, min, max, offset, count);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<Object>> reverseRangeByScoreWithScores(String key, double min, double max, long offset, long count) {
        return redisManager.getZSetStore().reverseRangeByScoreWithScores((Object)key, min, max, offset, count);
    }

    @Override
    public Long size(String key) {
        return redisManager.getZSetStore().zCard((Object)key);
    }

    @Override
    public Double score(String key, T value) {
        return redisManager.getZSetStore().score((Object)key, value);
    }

    @Override
    public Long removeRange(String key, long start, long end) {
        return redisManager.getZSetStore().removeRange((Object)key, start, end);
    }

    @Override
    public Long removeRangeByScore(String key, double min, double max) {
        return redisManager.getZSetStore().removeRangeByScore((Object)key, min, max);
    }

    @Override
    public Long unionAndStore(String key, String otherKey, String destKey) {
        return redisManager.getZSetStore().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    @Override
    public Long unionAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisManager.getZSetStore().unionAndStore((Object)key, otherKeys, (Object)destKey);
    }

    @Override
    public Long unionAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate) {
        return this.unionAndStore(key, otherKeys, destKey, aggregate, RedisZSetCommands.Weights.fromSetCount((int)(1 + otherKeys.size())));
    }

    @Override
    public Long unionAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        return redisManager.getZSetStore().unionAndStore((Object)key, otherKeys, (Object)destKey, aggregate, weights);
    }

    @Override
    public Long intersectAndStore(String key, String otherKey, String destKey) {
        return redisManager.getZSetStore().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    @Override
    public Long intersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        return redisManager.getZSetStore().intersectAndStore((Object)key, otherKeys, (Object)destKey);
    }

    @Override
    public Long intersectAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate) {
        return this.intersectAndStore(key, otherKeys, destKey, aggregate, RedisZSetCommands.Weights.fromSetCount((int)(1 + otherKeys.size())));
    }

    @Override
    public Long intersectAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        return redisManager.getZSetStore().intersectAndStore((Object)key, otherKeys, (Object)destKey, aggregate, weights);
    }

    @Override
    public Set<T> scan(String key, String pattern) {
        HashSet result = new HashSet();
        Cursor cursor = redisManager.getZSetStore().scan((Object)key, ScanOptions.scanOptions().count(10000L).match(pattern).build());
        cursor.forEachRemaining(result::add);
        cursor.close();
        return result;
    }

    @Override
    public void clear(String key) {
        this.removeRange(key, 0L, -1L);
    }
}

