/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.cloud.cache.support;

import com.feingto.cloud.cache.ICache;
import com.feingto.cloud.cache.IListCache;
import com.feingto.cloud.cache.ISetCache;
import com.feingto.cloud.cache.IZSetCache;
import com.feingto.cloud.cache.provider.RedisHashCache;
import com.feingto.cloud.cache.provider.RedisListProvider;
import com.feingto.cloud.cache.provider.RedisProvider;
import com.feingto.cloud.cache.provider.RedisSetProvider;
import com.feingto.cloud.cache.provider.RedisZSetProvider;
import com.feingto.cloud.cache.support.RestResponseErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configurable
public class CacheProviderAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CacheProviderAutoConfiguration.class);

    @LoadBalanced
    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        log.info("Load balanced bean '{}' has been injected", (Object)RestTemplate.class.getName());
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new RestResponseErrorHandler());
        return restTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public ICache redisProvider(RedisTemplate redisTemplate) {
        log.info("Bean '{}' has been injected", (Object)RedisProvider.class.getName());
        return new RedisProvider(redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisHashCache redisHashCache(RedisTemplate redisTemplate) {
        log.info("Bean '{}' has been injected", (Object)RedisHashCache.class.getName());
        return new RedisHashCache(redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public IListCache redisListProvider(RedisTemplate redisTemplate) {
        log.info("Bean '{}' has been injected", (Object)RedisListProvider.class.getName());
        return new RedisListProvider(redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public ISetCache redisSetProvider(RedisTemplate redisTemplate) {
        log.info("Bean '{}' has been injected", (Object)RedisSetProvider.class.getName());
        return new RedisSetProvider(redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public IZSetCache redisZSetProvider(RedisTemplate redisTemplate) {
        log.info("Bean '{}' has been injected", (Object)RedisZSetProvider.class.getName());
        return new RedisZSetProvider(redisTemplate);
    }
}

