/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.cloud.cache.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.feingto.cloud.kit.json.JSON;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.UnknownHttpStatusCodeException;

public class RestResponseErrorHandler
extends DefaultResponseErrorHandler {
    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = HttpStatus.resolve((int)response.getRawStatusCode());
        if (statusCode == null) {
            byte[] body = this.getResponseBody(response);
            String message = this.getErrorMessage(body, this.getCharset(response));
            throw new UnknownHttpStatusCodeException(message, response.getRawStatusCode(), response.getStatusText(), response.getHeaders(), body, this.getCharset(response));
        }
        this.handleError(response, statusCode);
    }

    private String getErrorMessage(@Nullable byte[] responseBody, @Nullable Charset charset) {
        charset = charset == null ? StandardCharsets.UTF_8 : charset;
        int maxChars = 200;
        if (responseBody.length < maxChars * 2) {
            return this.getJsonErrorMessage(new String(responseBody, charset));
        }
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(responseBody), charset);
            CharBuffer buffer = CharBuffer.allocate(maxChars);
            ((Reader)reader).read(buffer);
            ((Reader)reader).close();
            buffer.flip();
            return this.getJsonErrorMessage(buffer.toString());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String getJsonErrorMessage(String message) {
        JsonNode jsonNode = JSON.read((String)message);
        return jsonNode.has("message") ? jsonNode.get("message").asText() : message;
    }

    protected void handleError(ClientHttpResponse response, HttpStatus statusCode) throws IOException {
        String statusText = response.getStatusText();
        HttpHeaders headers = response.getHeaders();
        byte[] body = this.getResponseBody(response);
        Charset charset = this.getCharset(response);
        String message = this.getErrorMessage(body, charset);
        switch (statusCode.series()) {
            case CLIENT_ERROR: {
                throw HttpClientErrorException.create((String)message, (HttpStatus)statusCode, (String)statusText, (HttpHeaders)headers, (byte[])body, (Charset)charset);
            }
            case SERVER_ERROR: {
                throw HttpServerErrorException.create((String)message, (HttpStatus)statusCode, (String)statusText, (HttpHeaders)headers, (byte[])body, (Charset)charset);
            }
        }
        throw new UnknownHttpStatusCodeException(message, statusCode.value(), statusText, headers, body, charset);
    }
}

