package com.feingto.iot.server;

import com.feingto.iot.common.model.enums.Protocol;
import com.feingto.iot.server.bootstrap.IoTServerBootstrap;
import com.feingto.iot.server.config.properties.NettyProperties;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.scheduling.annotation.EnableScheduling;

import javax.annotation.Resource;

/**
 * IoT 服务端
 *
 * @author longfei
 */
@EnableScheduling
@SpringBootApplication
public class IoTServer implements CommandLineRunner {
    @Resource
    private NettyProperties config;

    public static void main(String[] args) {
        new SpringApplicationBuilder()
                .bannerMode(Banner.Mode.OFF)
                .sources(IoTServer.class)
                .run(args);
    }

    @Override
    public void run(String... args) {
        if (config.getPort() > 0) {
            new Thread(() -> new IoTServerBootstrap()
                    .protocol(Protocol.TCP)
                    .port(config.getPort())
                    .config(config)
                    .run()).start();
        }
        if (config.getWsPort() > 0) {
            new Thread(() -> new IoTServerBootstrap()
                    .protocol(Protocol.WS)
                    .port(config.getWsPort())
                    .config(config)
                    .run()).start();
        }
        if (config.getMqtt().getPort() > 0) {
            new Thread(() -> new IoTServerBootstrap()
                    .protocol(Protocol.MQTT)
                    .port(config.getMqtt().getPort())
                    .config(config)
                    .run()).start();
        }
        if (config.getMqtt().getWsPort() > 0) {
            new Thread(() -> new IoTServerBootstrap()
                    .protocol(Protocol.MQTT_WS)
                    .port(config.getMqtt().getWsPort())
                    .config(config)
                    .run()).start();
        }
    }
}
