package com.feingto.iot.server.cache;

import com.feingto.iot.common.model.mqtt.SessionStore;
import org.springframework.util.Assert;

import java.util.concurrent.ConcurrentHashMap;

/**
 * MQTT 会话缓存
 *
 * @author longfei
 */
public class SessionCache {
    private static SessionCache instance;
    /**
     * 会话Map key: clientId
     */
    private static ConcurrentHashMap<String, SessionStore> sessionMap = new ConcurrentHashMap<>();

    public static SessionCache getInstance() {
        if (instance == null) {
            instance = new SessionCache();
        }
        return instance;
    }

    /**
     * 获取会话
     */
    public SessionStore get(String clientId) {
        return sessionMap.get(clientId);
    }

    /**
     * 保存会话
     */
    public void put(String clientId, SessionStore message) {
        Assert.notNull(clientId, "The clientId parameter cannot be empty");
        sessionMap.put(clientId, message);
    }

    /**
     * 移除会话
     */
    public void remove(String clientId) {
        Assert.notNull(clientId, "The clientId parameter cannot be empty");
        sessionMap.remove(clientId);
    }
}
