package com.feingto.iot.server.config.properties;

import lombok.Data;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Ignite 属性配置
 */
@Data
@ConfigurationProperties(IgniteProperties.IGNITE_PREFIX)
public class IgniteProperties {
    public static final String IGNITE_PREFIX = "spring.data.ignite";

    /**
     * 系统线程池大小
     */
    private int threadPoolSize = IgniteConfiguration.DFLT_SYSTEM_CORE_THREAD_CNT;

    /**
     * 持久化存储目录路径
     */
    private String persistenceStorePath;

    /**
     * 持久化缓存内存初始化大小, 单位M
     */
    private long persistenceInitialSize;

    /**
     * 持久化缓存占用内存最大值, 单位M
     */
    private long persistenceMaxSize;

    /**
     * 非持久化缓存内存初始化大小, 单位M
     */
    private long NotPersistenceInitialSize;

    /**
     * 非持久化缓存占用内存最大值, 单位M
     */
    private long NotPersistenceMaxSize;

    private Broker broker;

    @Data
    public static class Broker {
        /**
         * 实例名
         */
        private String name;

        /**
         * 是否使用组播IP集群, 设为false使用静态IP集群
         */
        private boolean enableMulticastGroup;

        /**
         * 组播IP
         */
        private String multicastGroup;

        /**
         * 静态IP
         */
        private String[] staticIpAddresses = new String[]{};
    }
}
