package com.feingto.iot.server.config.properties;

import com.feingto.iot.common.model.mqtt.MqttConnectOptions;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * Netty 配置
 *
 * @author longfei
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "netty")
public class NettyProperties {
    private String host;

    private int port;

    private int wsPort;

    private int bossThread;

    private int workThread;

    /**
     * 缓冲区队列大小
     */
    private int backlog = 50;

    /**
     * 长连接
     */
    private boolean keepalive = true;

    private boolean ssl = false;

    private String keyStore;

    private String keyStorePassword;

    private MqttConnectOptions mqtt;
}
