package com.feingto.iot.server.handler;

import com.feingto.iot.common.handler.MessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessageType;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 消息处理抽象
 *
 * @author longfei
 */
@Slf4j
@Accessors(fluent = true)
public abstract class BaseMessageHandler implements MessageHandler {
    private MqttMessageType type;
    private List<BaseMessageHandler> filters = new ArrayList<>();

    public BaseMessageHandler(MqttMessageType type) {
        this.type = type;
    }

    public BaseMessageHandler filter(BaseMessageHandler filter) {
        this.filters.add(filter);
        return this;
    }

    public void proceed(MqttMessageType type, Channel channel, Object object) {
        if (this.type.equals(type)) {
            log.debug(">>> message type: {}", type);
            handle(channel, object);
            return;
        }
        this.filters.stream()
                .filter(Objects::nonNull)
                .filter(filter -> type.equals(filter.type))
                .findFirst()
                .ifPresent(filter -> filter.proceed(type, channel, object));
    }
}
