package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.Constants;
import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.model.mqtt.SubscribeMessage;
import com.feingto.iot.server.cache.MessageCache;
import com.feingto.iot.server.cache.SessionCache;
import com.feingto.iot.server.cache.SubscribeCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessageType;
import lombok.extern.slf4j.Slf4j;
import org.apache.ignite.IgniteCache;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 中断连接处理器
 *
 * @author longfei
 */
@Slf4j
@Component
public class DisconnectHandler extends BaseMessageHandler {
    @Resource(name = "igniteSubscribe")
    private IgniteCache<String, ConcurrentHashMap<String, SubscribeMessage>> igniteSubscribe;

    @Resource(name = "igniteMessage")
    private IgniteCache<String, ConcurrentHashMap<Integer, SendMessage>> igniteMessage;

    public DisconnectHandler() {
        super(MqttMessageType.DISCONNECT);
    }

    @Override
    public void handle(Channel channel, Object object) {
        String clientId = channel.attr(Constants.KEY_CLIENT_ID).get();
        Optional.ofNullable(SessionCache.getInstance().get(clientId))
                .ifPresent(sess -> {
                    // 从存储的会话状态中移除遗嘱消息
                    if (sess.willMessage() != null) {
                        log.debug(">>> remove will message of the {}", clientId);
                        sess.willMessage(null);
                    }
                    // cleanSession为true时清除会话
                    if (sess.cleanSession()) {
                        log.debug(">>> clean session of the {}", clientId);
                        SessionCache.getInstance().remove(clientId);
                        SubscribeCache.getInstance(igniteSubscribe).remove(clientId);
                        MessageCache.getInstance(igniteMessage).remove(clientId);
                    }
                    SessionCache.getInstance().remove(clientId);
                });
        channel.close();
    }
}
