package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.service.mqtt.MessageResponse;
import com.feingto.iot.server.handler.BaseMessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessageType;
import org.springframework.stereotype.Component;

/**
 * PING请求处理器
 *
 * @author longfei
 */
@Component
public class PingreqHandler extends BaseMessageHandler {
    public PingreqHandler() {
        super(MqttMessageType.PINGREQ);
    }

    @Override
    public void handle(Channel channel, Object object) {
        if (channel.isOpen() && channel.isActive() && channel.isWritable()) {
            // 返回pingresp消息
            MessageResponse.pingresp(channel);
        }
    }
}
