package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.Constants;
import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.server.cache.MessageCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import org.apache.ignite.IgniteCache;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Qos level = 2的协议流的第四个消息，除了消息类型外其他部分和PUBREL一致
 *
 * @author longfei
 */
@Component
public class PubcompHandler extends BaseMessageHandler {
    @Resource(name = "igniteMessage")
    private IgniteCache<String, ConcurrentHashMap<Integer, SendMessage>> igniteMessage;

    public PubcompHandler() {
        super(MqttMessageType.PUBCOMP);
    }

    @Override
    public void handle(Channel channel, Object object) {
        MqttMessage msg = (MqttMessage) object;
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader) msg.variableHeader();
        // 删除持久化消息
        MessageCache.getInstance(igniteMessage)
                .remove(channel.attr(Constants.KEY_CLIENT_ID).get(), variableHeader.messageId());
    }
}
