package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.Constants;
import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.service.mqtt.MessageResponse;
import com.feingto.iot.server.cache.MessageCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import org.apache.ignite.IgniteCache;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Qos level = 2的协议流的第二个消息，确认已经收到
 * 无论是订阅者还是服务器，在消费PUBREC消息之后需要发送一个PUBREL消息给发送者（和PUBREC具有同样的消息ID）
 *
 * @author longfei
 */
@Component
public class PubrecHandler extends BaseMessageHandler {
    @Resource(name = "igniteMessage")
    private IgniteCache<String, ConcurrentHashMap<Integer, SendMessage>> igniteMessage;

    public PubrecHandler() {
        super(MqttMessageType.PUBREC);
    }

    @Override
    public void handle(Channel channel, Object object) {
        MqttMessage msg = (MqttMessage) object;
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader) msg.variableHeader();
        int messageId = variableHeader.messageId();

        // 消息转入等待pubcomp阶段
        Optional.ofNullable(MessageCache.getInstance(igniteMessage)
                .get(channel.attr(Constants.KEY_CLIENT_ID).get(), messageId))
                .ifPresent(message -> message.type(MqttMessageType.PUBREL));

        // 返回pubrel消息
        MessageResponse.pubrel(channel, messageId);
    }
}
