package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.service.mqtt.MessageRequest;
import com.feingto.iot.common.service.mqtt.MessageResponse;
import com.feingto.iot.server.cache.MessageCache;
import com.feingto.iot.server.cache.SessionCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import lombok.extern.slf4j.Slf4j;
import org.apache.ignite.IgniteCache;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Qos level = 2的协议流的第三个消息
 *
 * @author longfei
 */
@Slf4j
@Component
public class PubrelHandler extends BaseMessageHandler {
    @Resource(name = "igniteMessage")
    private IgniteCache<String, ConcurrentHashMap<Integer, SendMessage>> igniteMessage;

    public PubrelHandler() {
        super(MqttMessageType.PUBREL);
    }

    @Override
    public void handle(Channel channel, Object object) {
        MqttMessage msg = (MqttMessage) object;
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader) msg.variableHeader();
        int messageId = variableHeader.messageId();

        Optional.ofNullable(MessageCache.getInstance(igniteMessage)
                .findByMessageId(messageId))
                .ifPresent(messages -> messages.forEach(map -> map.keySet()
                        // 发布消息到所有订阅者
                        .forEach(key -> Optional.ofNullable(SessionCache.getInstance().get(key))
                                .ifPresent(sess -> {
                                    log.debug(">>> send to {} with topic {}", key, map.get(key).topic());
                                    MessageRequest.publish(sess.channel(), map.get(key));
                                    // 删除持久化消息
                                    MessageCache.getInstance(igniteMessage).remove(key, messageId);
                                }))));

        // 返回pubcomp消息
        MessageResponse.pubcomp(channel, messageId);
    }
}
