package com.feingto.iot.server.handler.mqtt;

import com.feingto.iot.common.Constants;
import com.feingto.iot.common.model.mqtt.SubscribeMessage;
import com.feingto.iot.common.service.mqtt.MessageResponse;
import com.feingto.iot.server.cache.SubscribeCache;
import com.feingto.iot.server.handler.BaseMessageHandler;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import org.apache.ignite.IgniteCache;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Mqtt 消息取消订阅处理器
 *
 * @author longfei
 */
@Component
public class UnSubscribeHandler extends BaseMessageHandler {
    @Resource(name = "igniteSubscribe")
    private IgniteCache<String, ConcurrentHashMap<String, SubscribeMessage>> igniteSubscribe;

    public UnSubscribeHandler() {
        super(MqttMessageType.UNSUBSCRIBE);
    }

    @Override
    public void handle(Channel channel, Object object) {
        MqttUnsubscribeMessage msg = (MqttUnsubscribeMessage) object;
        msg.payload().topics().forEach(topic ->
                SubscribeCache.getInstance(igniteSubscribe)
                        .remove(topic, channel.attr(Constants.KEY_CLIENT_ID).get()));

        // 返回unsuback消息
        MessageResponse.unsuback(channel, msg.variableHeader().messageId());
    }
}
